<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD3RD_TRUST_PATH . '/class/AbstractListAction.class.php';

/**
 * Sd3rd_CostumeListAction
**/
class Sd3rd_CostumeListAction extends Sd3rd_AbstractListAction
{
    /**
     * &_getHandler
     * 
     * @param   void
     * 
     * @return  Sd3rd_CostumeHandler
    **/
    protected function &_getHandler()
    {
        $handler =& $this->mAsset->getObject('handler', 'Costume');
        return $handler;
    }

    /**
     * &_getFilterForm
     * 
     * @param   void
     * 
     * @return  Sd3rd_CostumeFilterForm
    **/
    protected function &_getFilterForm()
    {
        $filter =& $this->mAsset->getObject('filter', 'Costume',false);
        $filter->prepare($this->_getPageNavi(), $this->_getHandler());
        return $filter;
    }

    /**
     * _getBaseUrl
     * 
     * @param   void
     * 
     * @return  string
    **/
    protected function _getBaseUrl()
    {
        return './index.php?action=CostumeList';
    }

    /**
     * executeViewIndex
     * 
     * @param   XCube_RenderTarget  &$render
     * 
     * @return  void
    **/
    public function executeViewIndex(/*** XCube_RenderTarget ***/ &$render)
    {
        $render->setTemplateName($this->mAsset->mDirname . '_costume_list.html');
        #cubson::lazy_load_array('costume', $this->mObjects);
        $render->setAttribute('objects', $this->mObjects);
        $render->setAttribute('pageNavi', $this->mFilter->mNavi);
        $render->setAttribute('updateHandler',$this->mAsset->getObject('handler','Update'));
    }
}

?>
