<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

require_once SD3RD_TRUST_PATH . '/class/AbstractMasterHandler.class.php';

/**
 * Object of element.
**/
class Sd3rd_ElementObject extends XoopsSimpleObject
{
    /**
     * Constructor of this class.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('element_id',XOBJ_DTYPE_INT,'',false);
        $this->initVar('element_name',XOBJ_DTYPE_STRING,'',false);
    }
}

/**
 * Element master handler.
**/
class Sd3rd_ElementHandler extends Sd3rd_AbstractMasterHandler
{
    public /*** string ***/ $mClass = 'Sd3rd_ElementObject';
    public /*** string ***/ $mPrimary = 'element_id';
    protected /*** bool ***/ $_mCanCreate = false;
    protected /*** string ***/ $_mIdColumn = 'element_id';
    protected /*** string ***/ $_mValueColumn = 'element_name';
    
    /**
     * Create Sd3rd_ElementObject instance.
     * 
     * @param   int     $id
     * @param   string  $name
     * 
     * @return  Sd3rd_ElementObject
    **/
    protected function _create(/*** int ***/ $id,/*** string ***/ $name)
    {
        $obj = $this->create();
        $obj->set($this->_mIdColumn,$id);
        $obj->set($this->_mValueColumn,$name);
        return $obj;
    }
    
    /**
     * Create object list.
     * 
     * @param   CriteriaElement $cri
     * @param   int             $limit
     * @param   int             $offset
     * 
     * @return  XoopsSimpleObject[]
    **/
    public function getObjects(/*** CriteriaElement ***/ $cri = null,/*** int ***/ $limit = null,/*** int ***/ $offset = null)
    {
        $list = array(
            $this->_create(-3,_MD_SD3RD_LANG_ELEMENT_RANDOM),
            $this->_create(-2,_MD_SD3RD_LANG_ELEMENT_UNDEFINED),
            $this->_create(-1,_MD_SD3RD_LANG_ELEMENT_EMPTY),
        );
        for($i = 0;$i <= 12;$i++)
        {
            $list[] = $this->_create($i,constant('_MD_SD3RD_LANG_ELEMENT_' . $i));
        }
        return $list;
    }
}

?>
