<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Extract process for ChardataXXX.htm.
**/
class Sd3rd_ChardataExecute extends Sd3rd_AbstractExecute
{
    protected /*** string ***/ $_mParserPath = 'execute/parser/char';
    protected /*** Enum[] ***/ $_mTypeList = array(Sd3rd_HANDLER::CHAR);
    
    /**
     * Reset parser params.
     * 
     * @param   int $id
     * 
     * @return  void
    **/
    public function reset(/*** int ***/ $id)
    {
        parent::reset($id);
        foreach($this->_mTypeList as $type)
        {
            Sd3rd_Context::set($type,'eno',$id);
        }
    }
    
    /**
     * Finalize process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _dispose()
    {
        foreach($this->_mTypeList as $type)
        {
            $this->_insertObject($type);
        }
    }
    
    /**
     * Insert database at extract data.
     * 
     * @param   Enum    $type
     * 
     * @return  void
    **/
    protected function _insertObject(/*** Enum ***/ $type)
    {
        $obj = Sd3rd_UpdateUtils::createObject($type);
        $obj->setVars(Sd3rd_Context::getSection($type));
        Sd3rd_UpdateUtils::insertObject($type,$obj);
    }
}

?>
