<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Extract process for Chardata at costume.
**/
class Sd3rd_Costume_DataChar extends Sd3rd_AbstractParser
{
    protected /*** Sd3rd_CostumeHandler ***/ $_mHandler = null;
    
    /**
     * Constructor of this process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->_mHandler = Sd3rd_UpdateUtils::getHandler(Sd3rd_HANDLER::COSTUME);
    }
    
    /**
     * Latest main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function executeLatest()
    {
        $data = Sd3rd_UpdateUtils::parseByRegex($this->_mSource,"/\('(?P<name>[^']+)',(?P<clv>\d+),'(?P<exp>\d+)\/(?P<next>\d+)',(?P<cp>\d+),(?P<grow_life>\-?\d+),(?P<grow_soul>\-?\d+),(?P<grow_pow>\-?\d+),(?P<grow_str>\-?\d+),(?P<grow_dex>\-?\d+),(?P<grow_speed>\-?\d+),(?P<grow_mag>\-?\d+),(?P<grow_reg>\-?\d+),(?P<grow_con>\-?\d+),(?P<modify_hp>\-?\d+),(?P<modify_at>\-?\d+),(?P<modify_df>\-?\d+),(?P<modify_mat>\-?\d+),(?P<modify_mdf>\-?\d+),(?P<modify_hit>\-?\d+),(?P<modify_con>\-?\d+),(?P<modify_act>\-?\d+),(?P<modify_avoid>\-?\d+),(?P<move_cost>\d+),(?P<is_new>\d)\)/");
        $id = $this->_mHandler->getId($data['name'],array('grow_life' => $data['grow_life'],'grow_soul' => $data['grow_soul'],'grow_pow' => $data['grow_pow'],'grow_str' => $data['grow_str'],'grow_dex' => $data['grow_dex'],'grow_speed' => $data['grow_speed'],'grow_mag' => $data['grow_mag'],'grow_reg' => $data['grow_reg'],'grow_con' => $data['grow_con'],'modify_hp' => $data['modify_hp'],'modify_at' => $data['modify_at'],'modify_df' => $data['modify_df'],'modify_mat' => $data['modify_mat'],'modify_mdf' => $data['modify_mdf'],'modify_hit' => $data['modify_hit'],'modify_con' => $data['modify_con'],'modify_act' => $data['modify_act'],'modify_avoid' => $data['modify_avoid'],'move_cost' => $data['move_cost'],'register_time' => $this->_mUpdateTime),true);
    }
    
    /**
     * Main process for before 20090923.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute090923()
    {
        $data = Sd3rd_UpdateUtils::parseByRegex($this->_mSource,"/\('(?P<name>[^']+)',(?P<clv>\d+),'(?P<exp>\d+)\/(?P<next>\d+)',(?P<cp>\d+),(?P<grow_life>\-?\d+),(?P<grow_soul>\-?\d+),(?P<grow_pow>\-?\d+),(?P<grow_str>\-?\d+),(?P<grow_dex>\-?\d+),(?P<grow_speed>\-?\d+),(?P<grow_mag>\-?\d+),(?P<grow_reg>\-?\d+),(?P<grow_con>\-?\d+),(?P<modify_hp>\-?\d+),(?P<modify_at>\-?\d+),(?P<modify_df>\-?\d+),(?P<modify_mat>\-?\d+),(?P<modify_mdf>\-?\d+),(?P<modify_hit>\-?\d+),(?P<modify_con>\-?\d+),(?P<modify_act>\-?\d+),(?P<modify_avoid>\-?\d+),(?P<move_cost>\d+)\)/");
        $id = $this->_mHandler->getId($data['name'],array('grow_life' => $data['grow_life'],'grow_soul' => $data['grow_soul'],'grow_pow' => $data['grow_pow'],'grow_str' => $data['grow_str'],'grow_dex' => $data['grow_dex'],'grow_speed' => $data['grow_speed'],'grow_mag' => $data['grow_mag'],'grow_reg' => $data['grow_reg'],'grow_con' => $data['grow_con'],'modify_hp' => $data['modify_hp'],'modify_at' => $data['modify_at'],'modify_df' => $data['modify_df'],'modify_mat' => $data['modify_mat'],'modify_mdf' => $data['modify_mdf'],'modify_hit' => $data['modify_hit'],'modify_con' => $data['modify_con'],'modify_act' => $data['modify_act'],'modify_avoid' => $data['modify_avoid'],'move_cost' => $data['move_cost'],'register_time' => $this->_mUpdateTime),true);
    }
}

?>
