<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Extract process for Chardata at soul ability.
**/
class Sd3rd_SAbility_DataChar extends Sd3rd_AbstractParser
{
    protected /*** Sd3rd_AbilityHandler ***/ $_mHandler = null;
    
    /**
     * Constructor of this process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->_mHandler = Sd3rd_UpdateUtils::getHandler(Sd3rd_HANDLER::ABILITY);
    }
    
    /**
     * Latest main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function executeLatest()
    {
        $data = Sd3rd_UpdateUtils::parseByRegex($this->_mSource,"/\('(?P<name>[^']+)','(?P<desc>[^']+)',(?P<ac>\-?\d),(?P<flag>\d),'(?P<upgrade>[^']*)',(?P<is_new>\d)\)/");
        $id = $this->_mHandler->getId($data['name'],array('description' => $data['desc'],'ability_cost' => $data['ac'],'can_upgrade' => $data['flag'],'upgrade' => $data['upgrade'],'register_time' => $this->_mUpdateTime),true);
    }
    
    /**
     * Main process for before 20090923.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute090923()
    {
        $data = Sd3rd_UpdateUtils::parseByRegex($this->_mSource,"/\('(?P<name>[^']+)','(?P<desc>[^']+)',(?P<ac>\d),(?P<flag>\d),'(?P<upgrade>[^']*)'\)/");
        $id = $this->_mHandler->getId($data['name'],array('description' => $data['desc'],'ability_cost' => $data['ac'],'can_upgrade' => $data['flag'],'upgrade' => $data['upgrade'],'register_time' => $this->_mUpdateTime),true);
    }
}

?>
