<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * Refresh undurable tables.
**/
class Sd3rd_RefreshTablePrepare extends Sd3rd_AbstractFilter
{
    protected /*** Enum[] ***/ $_mRegisterTableList = array();
    protected /*** Enum[] ***/ $_mUpdateTableList = array();
    protected /*** Enum[] ***/ $_mTruncateTableList = array();
    protected /*** Enum[][] ***/ $_mCleanupTableList = array();
    
    /**
     * Get process priority.
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_9;
    }
    
    /**
     * Execute main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute()
    {
        parent::execute();
        $this->_refreshTableList($this->_mRegisterTableList,'DELETE FROM `%s` WHERE `register_time` >= %d');
        $this->_refreshTableList($this->_mUpdateTableList,'DELETE FROM `%s` WHERE `update_time` >= %d');
        $this->_refreshTableList($this->_mTruncateTableList,'TRUNCATE TABLE `%s`');
        array_walk($this->_mCleanupTableList,create_function('$v','call_user_func_array(array("Sd3rd_UpdateUtils","cleanupTable"),$v);'));
    }
    
    /**
     * Refresh table list.
     * 
     * @param   Enum[]  $list
     * @param   string  $query
     * 
     * @return  void
    **/
    protected function _refreshTableList(/*** Enum[] ***/ $list,/*** string ***/ $query)
    {
        $db =& XCube_Root::getSingleton()->mController->mDB;
        foreach(array_map(array('Sd3rd_UpdateUtils','convertTableName'),$list) as $table)
        {
            if(!$db->queryF(sprintf($query,$table,$this->_mUpdateTime)))
            {
                throw new Sd3rd_QueryErrorException(sprintf('Cannot refresh table at "%s".',$table));
            }
        }
    }
    
    /**
     * Latest main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function executeLatest()
    {
        $this->_mRegisterTableList = array(Sd3rd_HANDLER::ABILITY,Sd3rd_HANDLER::COSTUME,Sd3rd_HANDLER::SKILL);
        $this->_mUpdateTableList = array(Sd3rd_HANDLER::UPDATE);
        $this->_mTruncateTableList = array(Sd3rd_HANDLER::CHAR);
        $this->_mCleanupTableList = array(array(Sd3rd_HANDLER::SKILL,Sd3rd_HANDLER::SKILL_ELEMENT));
    }
    
    /**
     * First main process.
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function execute090527()
    {
        $this->_mTruncateTableList = array(
            Sd3rd_HANDLER::ABILITY,
            Sd3rd_HANDLER::CHAR,
            Sd3rd_HANDLER::COSTUME,
            Sd3rd_HANDLER::KIND,
            Sd3rd_HANDLER::SKILL,
            Sd3rd_HANDLER::SKILL_ELEMENT,
            Sd3rd_HANDLER::TARGET,
            Sd3rd_HANDLER::UPDATE
        );
    }
}

?>
