<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD3RD_TRUST_PATH . '/class/AbstractFilterForm.class.php';

define('SD3RD_SKILL_SORT_KEY_SKILL_NAME', 1);
define('SD3RD_SKILL_SORT_KEY_DEFAULT', SD3RD_SKILL_SORT_KEY_SKILL_NAME);

/**
 * Sd3rd_SkillFilterForm
**/
class Sd3rd_SkillFilterForm extends Sd3rd_AbstractFilterForm
{
    public /*** string[] ***/ $mSortKeys = array(
        SD3RD_SKILL_SORT_KEY_SKILL_NAME => 'skill_name',
    );

    /**
     * getDefaultSortKey
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function getDefaultSortKey()
    {
        return SD3RD_SKILL_SORT_KEY_DEFAULT;
    }

    /**
     * fetch
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function fetch()
    {
        parent::fetch();
        $request =& XCube_Root::getSingleton()->mContext->mRequest;
    
        if(($value = $request->getRequest('range')) !== null)
        {
            if(preg_match('/^-?\d+$/',$value))
            {
                $value = intval($value);
                $this->_mCriteria->add(new Criteria('range',$value));
            }
            else
            {
                $value = null;
            }
        }
        $this->mNavi->addExtra('range',$value);
    
        if(($value = $request->getRequest('target')) !== null)
        {
            if(ctype_digit($value))
            {
                $value = intval($value);
                $this->_mCriteria->add(new Criteria('target_id',$value));
            }
            else
            {
                $value = null;
            }
        }
        $this->mNavi->addExtra('target',$value);
    
        if(($value = $request->getRequest('kind')) !== null)
        {
            if(ctype_digit($value))
            {
                $value = intval($value);
                $this->_mCriteria->add(new Criteria('kind_id',$value));
            }
            else
            {
                $value = null;
            }
        }
        $this->mNavi->addExtra('kind',$value);
    
        if(($value = $request->getRequest('register_time')) !== null)
        {
            if(ctype_digit($value))
            {
                $value = intval($value);
                $this->_mCriteria->add(new Criteria('register_time',$value));
            }
        }
        $this->mNavi->addExtra('register_time', $value);
    
        $this->_mCriteria->addSort($this->getSort(), $this->getOrder());
    }
}

?>
