<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

if(!defined('SD3RD_TRUST_PATH'))
{
    define('SD3RD_TRUST_PATH',XOOPS_TRUST_PATH . '/modules/sd3rd');
}

require_once SD3RD_TRUST_PATH . '/class/Sd3rdUtils.class.php';

Sd3rd_AssetPreloadBase::prepare();


/**
 * Sd3rd_AssetPreloadBase
**/
class Sd3rd_AssetPreloadBase extends XCube_ActionFilter
{
    /**
     * prepare
     * 
     * @param   void
     * 
     * @return  void
    **/
    public static function prepare()
    {
        $root =& XCube_Root::getSingleton();
        $instance = new Sd3rd_AssetPreloadBase($root->mController);
        $root->mController->addActionFilter($instance);
    }

    /**
     * preBlockFilter
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function preBlockFilter()
    {
        $this->mRoot->mDelegateManager->add('Module.sd3rd.Global.Event.GetAssetManager','Sd3rd_AssetPreloadBase::getManager');
        $this->mRoot->mDelegateManager->add('Legacy_Utils.CreateModule','Sd3rd_AssetPreloadBase::getModule');
        $this->mRoot->mDelegateManager->add('Legacy_Utils.CreateBlockProcedure','Sd3rd_AssetPreloadBase::getBlock');
    }

    /**
     * getManager
     * 
     * @param   Sd3rd_AssetManager  &$obj
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public static function getManager(/*** Sd3rd_AssetManager ***/ &$obj,/*** string ***/ $dirname)
    {
        require_once SD3RD_TRUST_PATH . '/class/AssetManager.class.php';
        $obj = Sd3rd_AssetManager::getInstance($dirname);
    }

    /**
     * getModule
     * 
     * @param   Legacy_AbstractModule  &$obj
     * @param   XoopsModule  $module
     * 
     * @return  void
    **/
    public static function getModule(/*** Legacy_AbstractModule ***/ &$obj,/*** XoopsModule ***/ $module)
    {
        if($module->getInfo('trust_dirname') == 'sd3rd')
        {
            require_once SD3RD_TRUST_PATH . '/class/Module.class.php';
            $obj = new Sd3rd_Module($module);
        }
    }

    /**
     * getBlock
     * 
     * @param   Legacy_AbstractBlockProcedure  &$obj
     * @param   XoopsBlock  $block
     * 
     * @return  void
    **/
    public static function getBlock(/*** Legacy_AbstractBlockProcedure ***/ &$obj,/*** XoopsBlock ***/ $block)
    {
        $moduleHandler =& Sd3rd_Utils::getXoopsHandler('module');
        $module =& $moduleHandler->get($block->get('mid'));
        if(is_object($module) && $module->getInfo('trust_dirname') == 'sd3rd')
        {
            require_once SD3RD_TRUST_PATH . '/blocks/' . $block->get('func_file');
            $className = 'Sd3rd_' . substr($block->get('show_func'), 4);
            $obj = new $className($block);
        }
    }
}

?>
