<?php
/**
 * @file
 * @package sd3rd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

if(!defined('SD3RD_TRUST_PATH'))
{
    define('SD3RD_TRUST_PATH',XOOPS_TRUST_PATH . '/modules/sd3rd');
}

require_once SD3RD_TRUST_PATH . '/class/Sd3rdUtils.class.php';

//
// Define a basic manifesto.
//
$modversion['name'] = _MI_SD3RD_LANG_SD3RD;
$modversion['version'] = 0.1;
$modversion['description'] = _MI_SD3RD_DESC_SD3RD;
$modversion['author'] = _MI_SD3RD_LANG_AUTHOR;
$modversion['credits'] = _MI_SD3RD_LANG_CREDITS;
$modversion['license'] = 'GPL';
$modversion['official'] = 0;
$modversion['image'] = 'images/sd3rd.png';
$modversion['dirname'] = $myDirName;
$modversion['trust_dirname'] = 'sd3rd';

$modversion['cube_style'] = true;
$modversion['legacy_installer'] = array(
    'installer'   => array(
        'class'     => 'Installer',
        'namespace' => 'Sd3rd',
        'filepath'  => SD3RD_TRUST_PATH . '/admin/class/installer/Sd3rdInstaller.class.php'
    ),
    'uninstaller' => array(
        'class'     => 'Uninstaller',
        'namespace' => 'Sd3rd',
        'filepath'  => SD3RD_TRUST_PATH . '/admin/class/installer/Sd3rdUninstaller.class.php'
    ),
    'updater' => array(
        'class'     => 'Updater',
        'namespace' => 'Sd3rd',
        'filepath'  => SD3RD_TRUST_PATH . '/admin/class/installer/Sd3rdUpdater.class.php'
    )
);
$modversion['disable_legacy_2nd_installer'] = false;

$modversion['sqlfile']['mysql'] = 'sql/mysql.sql';
$modversion['tables'] = array(
//    '{prefix}_{dirname}_xxxx',
##[cubson:tables]
##[/cubson:tables]
);

//
// Templates. You must never change [cubson] chunk to get the help of cubson.
//
$modversion['templates'] = array(
/*
    array(
        'file'        => '{dirname}_xxx.html',
        'description' => _MI_SD3RD_TPL_XXX
    ),
*/
##[cubson:templates]
    array('file' => '{dirname}_ability_list.html','description' => _MI_SD3RD_TPL_ABILITY_LIST),
    array('file' => '{dirname}_costume_list.html','description' => _MI_SD3RD_TPL_COSTUME_LIST),
    array('file' => '{dirname}_skill_list.html','description' => _MI_SD3RD_TPL_SKILL_LIST),
##[/cubson:templates]
);

//
// Admin panel setting
//
$modversion['hasAdmin'] = 0;

//
// Public side control setting
//
$modversion['hasMain'] = 1;
$modversion['hasSearch'] = 0;
$modversion['sub'] = array(
/*
    array(
        'name' => _MI_SD3RD_LANG_SUB_XXX,
        'url'  => 'index.php?action=XXX'
    ),
*/
##[cubson:submenu]
##[/cubson:submenu]
);

//
// Config setting
//
$modversion['config'] = array(
/*
    array(
        'name'          => 'xxxx',
        'title'         => '_MI_SD3RD_TITLE_XXXX',
        'description'   => '_MI_SD3RD_DESC_XXXX',
        'formtype'      => 'xxxx',
        'valuetype'     => 'xxx',
        'options'       => array(xxx => xxx,xxx => xxx),
        'default'       => 0
    ),
*/
##[cubson:config]
##[/cubson:config]
);

//
// Block setting
//
$modversion['blocks'] = array(
/*
    x => array(
        'func_num'          => x,
        'file'              => 'xxxBlock.class.php',
        'class'             => 'xxx',
        'name'              => _MI_SD3RD_BLOCK_NAME_xxx,
        'description'       => _MI_SD3RD_BLOCK_DESC_xxx,
        'options'           => '',
        'template'          => '{dirname}_block_xxx.html',
        'show_all_module'   => true,
        'visible_any'       => true
    ),
*/
##[cubson:block]
##[/cubson:block]
);

?>
