﻿#region License
/* **********************************************************************************
 * Copyright (c) Roman Ivantsov
 * This source code is subject to terms and conditions of the MIT License
 * for Irony. A copy of the license can be found in the License.txt file
 * at the root of this distribution. 
 * By using this source code in any fashion, you are agreeing to be bound by the terms of the 
 * MIT License.
 * You must not remove this notice from this software.
 * **********************************************************************************/
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Irony.Ast;
using Irony.Parsing;

namespace Irony.Interpreter.Ast
{

    public class EvalNode : AstNode
    {
        private AstNode BodyAst;

        public override void Init(AstContext context , ParseTreeNode treeNode)
        {
            base.Init(context , treeNode);

            //実行するEval文字列をASTノードとして追加
            BodyAst = AddChild(NodeUseType.ValueReadWrite , "body" , treeNode.ChildNodes[2]);


            AsString = "Eval";
        }

        protected override object DoEvaluate(ScriptThread thread)
        {
            thread.CurrentNode = this;  //standard prolog
            object result = null;

            //パース
            var parseTree = thread.App.Parser.Parse(BodyAst.Evaluate(thread).ToString());
            //実行
            result = thread.App.Evaluate(parseTree , thread.CurrentScope);



        //****************************************************************
            thread.CurrentNode = Parent; //standard epilog
            return result;
        }//method

    }//class

}//namespace
