﻿#region License
/* **********************************************************************************
 * Copyright (c) Roman Ivantsov
 * This source code is subject to terms and conditions of the MIT License
 * for Irony. A copy of the license can be found in the License.txt file
 * at the root of this distribution. 
 * By using this source code in any fashion, you are agreeing to be bound by the terms of the 
 * MIT License.
 * You must not remove this notice from this software.
 * **********************************************************************************/
#endregion

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Irony.Ast;
using Irony.Parsing;

namespace Irony.Interpreter.Ast
{

    public class getIDsNode : AstNode
    {

        public override void Init(AstContext context , ParseTreeNode treeNode)
        {
            base.Init(context , treeNode);

            AsString = "Test";
        }

        protected override object DoEvaluate(ScriptThread thread)
        {
            thread.CurrentNode = this;  //standard prolog
            var result = new List<SlotInfo>();
 
            //******************************************
            var s = "";
            foreach(var info in thread.App.DataMap.StaticScopeInfos)
            {
                foreach (var sl in info.GetSlots())
                {
                    if (sl.Name == "null" || sl.Name == "false" || sl.Name == "true")
                        continue;

                    s += sl.Name + " type: " + sl.Type.ToString()  + Environment.NewLine;
                    var temp = thread.Bind(sl.Name , BindingRequestFlags.Read);

                    if (temp.GetValueRef == null)
                        continue;

                    var temp2 = temp.GetValueRef(thread);
                    s += "val " + temp2.ToString() + Environment.NewLine;

                    result.Add(sl);

                }
            }

            s += "local ----------------------------" + Environment.NewLine;

            var cur = thread.CurrentScope.Info.GetSlots();
            foreach (var sl in cur)
            {
                s += sl.Name + " type: " + sl.ScopeInfo.Level + Environment.NewLine;
                result.Add(sl);
            }

            System.Diagnostics.Debug.WriteLine(s);


        //****************************************************************
            thread.CurrentNode = Parent; //standard epilog
            return result;
        }//method

    }//class

}//namespace
