﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ScriptRunner;
using Irony.Interpreter;

namespace ScriptEditor
{
    public partial class MainForm : Form
    {

        public ScriptRunner.Runner sr;
        private int dummyfilenameCnt=0;

        public MainForm()
        {
            sr = new Runner(App_ConsoleWrite, App_ClearText);
            InitializeComponent();
            this.Text = "ScriptEditor";
        }


        //run
        private void runToolStripMenuItem1_Click(object sender , EventArgs e)
        {
            try
            {
                sr.Run( ((FastColoredTextBoxNS.FastColoredTextBox)tabControl1.SelectedTab.Controls[0]).Text );
                //sus = false;
            }
            catch (ScriptException ex)
            {
                MessageBox.Show(ex.Location.ToUiString() + ex.Message);
            }

            
        }


    
        private void textBox_Prompt_KeyUp(object sender , KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Return)
            {
                switch (textBox_Prompt.Text.ToLower())
                {
                    case "resume":
                        sr.Resume();
                        break;

                    case "debug":
                        sr.debug();
                        break;
                        
                    case "watch":
                        sr.watchVariables(this.listView_watchVariable);
                        //listView_watchVariable.Items.Clear();
                        //listView_watchVariable.Items.Add(new ListViewItem(new string[] { "aaaa" , "3" }));
                        break;
                    default:
                        sr.Run(textBox_Prompt.Text);
                        break;
                }
            }
        }


        //print
        delegate void SetTextDelegate(object sender , ConsoleWriteEventArgs e);
        public void App_ConsoleWrite(object sender , ConsoleWriteEventArgs e)
        {
            if (InvokeRequired)
            {
                // 別スレッドから呼び出された場合
                this.BeginInvoke(new SetTextDelegate(App_ConsoleWrite) , new object[] { sender , e });
                return;
            }
            this.textBox_info.Text += e.Text;
        }

        //App_ClearText
        delegate void ClearTextDelegate(object sender, ConsoleWriteEventArgs e);
        public void App_ClearText(object sender, ConsoleWriteEventArgs e)
        {
            if(InvokeRequired)
            {
                // 別スレッドから呼び出された場合
                this.BeginInvoke(new ClearTextDelegate(App_ClearText), new object[] { sender, e });
                return;
            }
            this.textBox_info.Text = "";
        }



        private void textBox_Prompt_TextChanged(object sender , EventArgs e)
        {

        }

        //resume
        private void ResumeToolStripMenuItem_Click(object sender , EventArgs e)
        {
            sr.Resume();
        }

        //open
        private void 開くOToolStripMenuItem_Click(object sender , EventArgs e)
        {
            var ret = openFileDialog1.ShowDialog();
            if (ret == System.Windows.Forms.DialogResult.OK)
            {

                //タブを追加　キー、表示名ともファイルフルパス
                this.tabControl1.TabPages.Add(openFileDialog1.FileName, openFileDialog1.FileName);

                var coloredtextbox = new SyntaxHighlightTextBox(sr, ilAutocomplete, openFileDialog1.FileName);
                this.tabControl1.TabPages[openFileDialog1.FileName].Controls.Add(coloredtextbox);
                coloredtextbox.Text = System.IO.File.ReadAllText(openFileDialog1.FileName);
                
                //流し込んだ時点でdirtyとなるが、実際は変更されてない
                coloredtextbox.dirty = false;
            }
        }

        //save as
        private void 名前を付けて保存AToolStripMenuItem_Click(object sender , EventArgs e)
        {
            var ret = saveFileDialog1.ShowDialog();
            if (ret == System.Windows.Forms.DialogResult.OK)
            {
                System.IO.File.WriteAllText(saveFileDialog1.FileName, ((SyntaxHighlightTextBox)tabControl1.SelectedTab.Controls[0]).Text);
                //filename = saveFileDialog1.FileName;
                //this.Text = "ScriptEditor - " + filename;
            }
        }

        //save
        private void 上書き保存SToolStripMenuItem_Click(object sender , EventArgs e)
        {
            
            var filename =  ((SyntaxHighlightTextBox)tabControl1.SelectedTab.Controls[0]).Filename;
            if(System.IO.File.Exists(filename) == true)
            {
                System.IO.File.WriteAllText(filename, ((SyntaxHighlightTextBox)tabControl1.SelectedTab.Controls[0]).Text);
            }
            else
            {
                var ret = saveFileDialog1.ShowDialog();
                if(ret == System.Windows.Forms.DialogResult.OK)
                {
                    System.IO.File.WriteAllText(saveFileDialog1.FileName, ((SyntaxHighlightTextBox)tabControl1.SelectedTab.Controls[0]).Text);
                }
            }
        }

        //reset
        private void resetToolStripMenuItem_Click(object sender , EventArgs e)
        {
            sr.Reset();
            sr = null;
            sr = new Runner(App_ConsoleWrite, App_ClearText);
        }

        private void newToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //タブを追加　キー、表示名ともファイルフルパス
            dummyfilenameCnt++;
            var dummyfilename = dummyfilenameCnt.ToString();
            this.tabControl1.TabPages.Add(dummyfilename , "new " + dummyfilenameCnt.ToString());

            var coloredtextbox = new SyntaxHighlightTextBox(sr, ilAutocomplete, "");
            this.tabControl1.TabPages[dummyfilename].Controls.Add(coloredtextbox);
            coloredtextbox.dirty = false;

        }

        private void 終了XToolStripMenuItem_Click(object sender, EventArgs e)
        {
            foreach(TabPage tab in this.tabControl1.TabPages)
            {
                var tb = tab.Controls[0] as SyntaxHighlightTextBox;
                if(tb != null)
                {
                    if(tb.dirty)
                    {
                        var ret = MessageBox.Show(tab.Text + "は変更されています。保存しますか？" , "確認" , MessageBoxButtons.YesNo);
                        if(ret == System.Windows.Forms.DialogResult.Yes)
                            上書き保存SToolStripMenuItem_Click(null, EventArgs.Empty);
                    }
                }
            }
            this.Close();
        }






    }
}
