/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CSensor;
import lejos.nxt.SensorPort;

public class LServo
extends I2CSensor {
    private String servoName = "";
    private int angle;
    private int speed;
    private int min_angle;
    private int max_angle;
    private SensorPort portConnected;
    private byte SPI_PORT;
    private int servo;
    int I2C_Response;
    private byte[] bufReadResponse;
    private byte h_byte;
    private byte l_byte;

    public LServo(SensorPort port, int location, String servoName, byte SPI_PORT) {
        super(port);
        this.servoName = servoName;
        this.SPI_PORT = SPI_PORT;
        this.bufReadResponse = new byte[8];
        this.setAddress(40);
    }

    public void setAngle(int servo, int angle) throws Exception {
        this.h_byte = (byte)(0x80 | (servo << 3 | angle >> 8));
        this.l_byte = (byte)angle;
        this.I2C_Response = this.sendData(this.SPI_PORT, this.h_byte);
        this.I2C_Response = this.sendData(this.SPI_PORT, this.l_byte);
    }

    public int getAngle(int Servo) throws Exception {
        this.h_byte = (byte)(Servo << 3);
        this.I2C_Response = this.sendData(this.SPI_PORT, this.h_byte);
        this.I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        this.I2C_Response = this.getData(this.SPI_PORT, this.bufReadResponse, 1);
        this.h_byte = this.bufReadResponse[0];
        this.I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        this.I2C_Response = this.getData(this.SPI_PORT, this.bufReadResponse, 1);
        this.l_byte = this.bufReadResponse[0];
        return ((this.h_byte & 7) << 8) + (this.l_byte & 0xFF);
    }

    public int readMotion() throws Exception {
        int motion = -1;
        this.I2C_Response = this.sendData(this.SPI_PORT, (byte)104);
        this.I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        this.I2C_Response = this.getData(this.SPI_PORT, this.bufReadResponse, 1);
        this.h_byte = this.bufReadResponse[0];
        this.I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        this.I2C_Response = this.getData(this.SPI_PORT, this.bufReadResponse, 1);
        this.l_byte = this.bufReadResponse[0];
        motion = this.l_byte == 255 ? ((this.h_byte & 7) << 8) + 255 : (this.h_byte & 7) << 8 | this.l_byte & 0xFF;
        return motion;
    }

    public boolean isMoving() throws Exception {
        boolean flag = false;
        if (this.readMotion() != 0) {
            flag = true;
        }
        return flag;
    }

    public void setDelay(int Servo, int delay) {
        this.h_byte = (byte)-16;
        this.l_byte = (byte)((Servo << 4) + delay);
        this.I2C_Response = this.sendData(this.SPI_PORT, this.h_byte);
        this.I2C_Response = this.sendData(this.SPI_PORT, this.l_byte);
    }

    public void setMinAngle(int minAngle) {
        this.min_angle = minAngle;
    }

    public void setMaxAngle(int maxAngle) {
        this.max_angle = maxAngle;
    }

    public void goToMinAngle() throws Exception {
        this.setAngle(1, this.min_angle);
    }

    public void goToMaxAngle() throws Exception {
        this.setAngle(1, this.max_angle);
    }

    public void goToMiddleAngle() throws Exception {
        float middle = (this.min_angle + this.max_angle) / 2;
        this.setAngle(1, Math.round(middle));
    }

    public String getName() {
        return this.servoName;
    }
}

