/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.comm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lejos.nxt.comm.BTConnection;
import lejos.nxt.comm.USBConnection;

public class NXTSocket {
    private DataOutputStream outToProxy;
    private DataInputStream inFromProxy;
    private BTConnection btc;
    private USBConnection usbc;
    private String host;
    private int port;
    private boolean isBluetooth;
    private boolean isServer = false;

    public NXTSocket(String host, int port, BTConnection btc) throws IOException {
        this.host = host;
        this.port = port;
        this.btc = btc;
        this.inFromProxy = new DataInputStream(btc.openInputStream());
        this.outToProxy = new DataOutputStream(btc.openOutputStream());
        this.isBluetooth = true;
        this.negotiateConnection();
        this.outToProxy.close();
        this.inFromProxy.close();
    }

    public NXTSocket(String host, int port, USBConnection usbc) throws IOException {
        this.host = host;
        this.port = port;
        this.usbc = usbc;
        this.inFromProxy = new DataInputStream(this.btc.openInputStream());
        this.outToProxy = new DataOutputStream(this.btc.openOutputStream());
        this.isBluetooth = false;
        this.negotiateConnection();
        this.outToProxy.close();
        this.inFromProxy.close();
    }

    public NXTSocket(BTConnection btc) {
        this.btc = btc;
        this.isBluetooth = true;
    }

    public NXTSocket(USBConnection usbc) {
        this.usbc = usbc;
        this.isBluetooth = false;
    }

    private void negotiateConnection() throws IOException {
        if (this.host.length() == 0) {
            throw new IOException();
        }
        this.outToProxy = new DataOutputStream(this.btc.openOutputStream());
        this.outToProxy.writeBoolean(this.isServer);
        this.outToProxy.writeByte(this.host.length());
        this.outToProxy.writeChars(this.host);
        this.outToProxy.writeInt(this.port);
        this.outToProxy.flush();
        if (!this.inFromProxy.readBoolean()) {
            throw new IOException();
        }
    }

    public DataInputStream getDataInputStream() throws IOException {
        if (this.isBluetooth) {
            return new DataInputStream(this.btc.openInputStream());
        }
        return new DataInputStream(this.usbc.openInputStream());
    }

    public DataOutputStream getDataOutputStream() throws IOException {
        if (this.isBluetooth) {
            return new DataOutputStream(this.btc.openOutputStream());
        }
        return new DataOutputStream(this.usbc.openOutputStream());
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isBluetooth) {
            return this.btc.openOutputStream();
        }
        return this.usbc.openOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        if (this.isBluetooth) {
            return this.btc.openInputStream();
        }
        return this.usbc.openInputStream();
    }
}

