/*
 * Decompiled with CFR 0.152.
 */
package lejos.rcxcomm;

import lejos.nxt.SensorPort;
import lejos.rcxcomm.LLC;
import lejos.rcxcomm.PacketHandler;

public class LLCHandler
extends PacketHandler {
    private byte op;
    private boolean gotAck = false;
    private boolean gotPacket = false;
    private byte[] inPacket = new byte[3];
    private byte[] ackPacket = new byte[2];
    private int inPacketLength;

    public LLCHandler(SensorPort port) {
        LLC.init(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPacket(byte[] packet, int len) {
        LLCHandler lLCHandler = this;
        synchronized (lLCHandler) {
            boolean res = LLC.sendBytes(packet, len);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return res;
        }
    }

    public int receivePacket(byte[] buffer) {
        this.gotPacket = false;
        for (int i = 0; i < this.inPacketLength; ++i) {
            buffer[i] = this.inPacket[i];
        }
        return this.inPacketLength;
    }

    public int receiveAck(byte[] buffer) {
        this.gotAck = false;
        for (int i = 0; i < 2; ++i) {
            buffer[i] = this.ackPacket[i];
        }
        return 2;
    }

    private void getOp() {
        do {
            int r;
            if ((r = LLC.read()) < 0) {
                return;
            }
            this.op = (byte)r;
            if ((this.op & 0xF7) != 241) continue;
            this.gotPacket = true;
            this.inPacket[0] = this.op;
            int extra = (this.op & 7) + 1;
            for (int i = 0; i < extra; ++i) {
                this.inPacket[i + 1] = (byte)LLC.receive();
            }
            this.inPacketLength = extra + 1;
            return;
        } while ((this.op & 0xF7) != 240);
        this.gotAck = true;
        this.ackPacket[0] = this.op;
        this.ackPacket[1] = (byte)LLC.receive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPacketAvailable() {
        LLCHandler lLCHandler = this;
        synchronized (lLCHandler) {
            if (this.gotPacket) {
                return true;
            }
            this.getOp();
            return this.gotPacket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAckAvailable() {
        LLCHandler lLCHandler = this;
        synchronized (lLCHandler) {
            if (this.gotAck) {
                return true;
            }
            this.getOp();
            return this.gotAck;
        }
    }
}

