/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.bluetooth.DataElement;
import javax.bluetooth.UUID;

class SDPOutputStream
extends OutputStream {
    OutputStream dst;

    public SDPOutputStream(OutputStream out) {
        this.dst = out;
    }

    public void write(int oneByte) throws IOException {
        this.dst.write(oneByte);
    }

    private void writeLong(long l, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            this.write((int)(l >> (size - 1 << 3)));
            l <<= 8;
        }
    }

    private void writeBytes(byte[] b) throws IOException {
        for (int i = 0; i < b.length; ++i) {
            this.write(b[i]);
        }
    }

    private int getLength(DataElement d) {
        switch (d.getDataType()) {
            case 0: {
                return 1;
            }
            case 8: 
            case 16: 
            case 40: {
                return 2;
            }
            case 9: 
            case 17: {
                return 3;
            }
            case 10: 
            case 18: {
                return 5;
            }
            case 11: 
            case 19: {
                return 9;
            }
            case 12: 
            case 20: 
            case 24: {
                return 17;
            }
            case 32: {
                byte[] b = Utils.getUTF8Bytes((String)d.getValue());
                if (b.length < 256) {
                    return b.length + 2;
                }
                if (b.length < 65536) {
                    return b.length + 3;
                }
                return b.length + 5;
            }
            case 64: {
                byte[] b = Utils.getASCIIBytes((String)d.getValue());
                if (b.length < 256) {
                    return b.length + 2;
                }
                if (b.length < 65536) {
                    return b.length + 3;
                }
                return b.length + 5;
            }
            case 48: 
            case 56: {
                int result = 5;
                Enumeration e = (Enumeration)d.getValue();
                while (e.hasMoreElements()) {
                    result += this.getLength((DataElement)e.nextElement());
                }
                return result;
            }
        }
        throw new IllegalArgumentException();
    }

    public void writeElement(DataElement d) throws IOException {
        switch (d.getDataType()) {
            case 0: {
                this.write(0);
                break;
            }
            case 8: {
                this.write(8);
                this.writeLong(d.getLong(), 1);
                break;
            }
            case 9: {
                this.write(9);
                this.writeLong(d.getLong(), 2);
                break;
            }
            case 10: {
                this.write(10);
                this.writeLong(d.getLong(), 4);
                break;
            }
            case 11: {
                this.write(11);
                this.writeBytes((byte[])d.getValue());
                break;
            }
            case 12: {
                this.write(12);
                this.writeBytes((byte[])d.getValue());
                break;
            }
            case 16: {
                this.write(16);
                this.writeLong(d.getLong(), 1);
                break;
            }
            case 17: {
                this.write(17);
                this.writeLong(d.getLong(), 2);
                break;
            }
            case 18: {
                this.write(18);
                this.writeLong(d.getLong(), 4);
                break;
            }
            case 19: {
                this.write(19);
                this.writeLong(d.getLong(), 8);
                break;
            }
            case 20: {
                this.write(20);
                this.writeBytes((byte[])d.getValue());
                break;
            }
            case 24: {
                this.write(28);
                this.writeBytes(Utils.UUIDToByteArray((UUID)d.getValue()));
                break;
            }
            case 32: {
                byte[] b = Utils.getUTF8Bytes((String)d.getValue());
                if (b.length < 256) {
                    this.write(37);
                    this.writeLong(b.length, 1);
                } else if (b.length < 65536) {
                    this.write(38);
                    this.writeLong(b.length, 2);
                } else {
                    this.write(39);
                    this.writeLong(b.length, 4);
                }
                this.writeBytes(b);
                break;
            }
            case 40: {
                this.write(40);
                this.writeLong(d.getBoolean() ? 1L : 0L, 1);
                break;
            }
            case 48: {
                this.write(55);
                this.writeLong(this.getLength(d) - 5, 4);
                Enumeration e = (Enumeration)d.getValue();
                while (e.hasMoreElements()) {
                    this.writeElement((DataElement)e.nextElement());
                }
                break;
            }
            case 56: {
                this.write(63);
                this.writeLong(this.getLength(d) - 5, 4);
                Enumeration e = (Enumeration)d.getValue();
                while (e.hasMoreElements()) {
                    this.writeElement((DataElement)e.nextElement());
                }
                break;
            }
            case 64: {
                byte[] b = Utils.getASCIIBytes((String)d.getValue());
                if (b.length < 256) {
                    this.write(69);
                    this.writeLong(b.length, 1);
                } else if (b.length < 65536) {
                    this.write(70);
                    this.writeLong(b.length, 2);
                } else {
                    this.write(71);
                    this.writeLong(b.length, 4);
                }
                this.writeBytes(b);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }
}

