/*
 * Decompiled with CFR 0.152.
 */
package java.util;

public class ArrayList {
    private static final int INITIAL_CAPACITY = 7;
    private static final int CAPACITY_INCREMENT = 3;
    protected Object[] elementData;
    protected int capacityIncrement;
    protected int elementCount;

    public ArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            initialCapacity = 0;
        }
        this.elementData = new Object[initialCapacity];
        this.capacityIncrement = 3;
        this.elementCount = 0;
    }

    public ArrayList(Object[] elements) {
        this(elements.length * 13 / 10);
        this.addAll(elements);
    }

    public ArrayList() {
        this(7);
    }

    public void add(int index, Object element) {
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.ensureCapacity(this.elementCount + 1);
        for (int i = this.elementCount; i > index; --i) {
            this.elementData[i] = this.elementData[i - 1];
        }
        this.elementData[index] = element;
        ++this.elementCount;
    }

    public void add(Object o) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = o;
    }

    public void addAll(Object[] elements) {
        if (elements == null) {
            return;
        }
        this.ensureCapacity(this.elementCount + elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.elementData[this.elementCount++] = elements[i];
        }
    }

    public void addAll(int index, Object[] elements) {
        int i;
        if (elements == null) {
            return;
        }
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.ensureCapacity(this.elementCount + elements.length);
        for (i = this.elementCount + elements.length - 1; i > index; --i) {
            this.elementData[i] = this.elementData[i - elements.length];
        }
        for (i = 0; i < elements.length; ++i) {
            this.elementData[i + index] = elements[i];
            ++this.elementCount;
        }
    }

    public void clear() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
    }

    public boolean contains(Object o) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (!this.elementData[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public Object get(int index) {
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elementData[index];
    }

    public int indexOf(Object o) {
        for (int i = 0; i < this.elementCount; ++i) {
            if (!this.elementData[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        for (int i = this.elementCount - 1; i >= 0; --i) {
            if (!this.elementData[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Object remove(int index) {
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object o = this.elementData[index];
        for (int i = index; i < this.elementCount; ++i) {
            this.elementData[i] = this.elementData[i + 1];
        }
        --this.elementCount;
        return o;
    }

    public Object set(int index, Object element) {
        if (index > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object o = this.elementData[index];
        this.elementData[index] = element;
        return o;
    }

    public int size() {
        return this.elementCount;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.elementData.length < minCapacity) {
            int newCapacity;
            int n = newCapacity = this.capacityIncrement > 0 ? this.elementData.length + this.capacityIncrement : this.elementData.length * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] oldData = this.elementData;
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }
}

