/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import lejos.nxt.comm.Bluetooth;

public class LocalDevice {
    private static LocalDevice localDevice;

    private LocalDevice() {
    }

    public static LocalDevice getLocalDevice() throws BluetoothStateException {
        if (localDevice == null) {
            localDevice = new LocalDevice();
        }
        return localDevice;
    }

    public String getFriendlyName() {
        char[] nameChars = this.convertBytesToChars(Bluetooth.getFriendlyName());
        String fName = new String(nameChars);
        return fName.substring(0, fName.indexOf(0));
    }

    public boolean setFriendlyName(String name) {
        byte[] nameBytes = this.convertCharsToBytes(name.toCharArray(), 16);
        return Bluetooth.setFriendlyName(nameBytes);
    }

    protected byte[] convertCharsToBytes(char[] charArray, int length) {
        byte[] byteArray = new byte[length];
        for (int i = 0; i < charArray.length; i = (int)((byte)(i + 1))) {
            byteArray[i] = (byte)charArray[i];
        }
        return byteArray;
    }

    protected char[] convertBytesToChars(byte[] byteArray) {
        char[] charArray = new char[byteArray.length];
        for (int i = 0; i < charArray.length; i = (int)((byte)(i + 1))) {
            charArray[i] = (char)byteArray[i];
        }
        return charArray;
    }

    public DeviceClass getDeviceClass() {
        return new DeviceClass(4063488);
    }

    public boolean setDiscoverable(int mode) throws BluetoothStateException {
        int ret = Bluetooth.setVisibility((byte)(mode != 0 ? 1 : 0));
        return ret >= 0;
    }

    public static boolean isPowerOn() {
        return Bluetooth.getPower();
    }

    public int getDiscoverable() {
        return Bluetooth.getVisibility();
    }

    public static String getProperty(String property) {
        return null;
    }

    public String getBluetoothAddress() {
        byte[] addr = Bluetooth.getLocalAddress();
        return Bluetooth.addressToString(addr);
    }
}

