/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CPort;
import lejos.nxt.SensorConstants;

public class I2CSensor
implements SensorConstants {
    I2CPort port;
    int address = 1;
    String version = null;
    String productID = null;
    String sensorType = null;
    byte[] byteBuff = new byte[8];
    byte[] buf1 = new byte[1];
    String BLANK = "        ";

    public I2CSensor(I2CPort port) {
        this.port = port;
        port.i2cEnable();
        port.setType(10);
    }

    public int getData(int register, byte[] buf, int len) {
        int ret = this.port.i2cStart(this.address, register, len, buf, len, 0);
        if (ret != 0) {
            return ret;
        }
        while (this.port.i2cBusy() != 0) {
            Thread.yield();
        }
        return 0;
    }

    public int sendData(int register, byte[] buf, int len) {
        int ret = this.port.i2cStart(this.address, register, len, buf, len, 1);
        if (ret != 0) {
            return ret;
        }
        while (this.port.i2cBusy() != 0) {
            Thread.yield();
        }
        return 0;
    }

    public int sendData(int register, byte value) {
        this.buf1[0] = value;
        return this.sendData(register, this.buf1, 1);
    }

    public String getVersion() {
        int ret = this.getData(0, this.byteBuff, 8);
        if (ret != 0) {
            return this.BLANK;
        }
        char[] charBuff = new char[8];
        for (int i = 0; i < 8; ++i) {
            charBuff[i] = (char)this.byteBuff[i];
        }
        this.version = new String(charBuff, 0, 8);
        return this.version;
    }

    public String getProductID() {
        int ret = this.getData(8, this.byteBuff, 8);
        if (ret != 0) {
            return this.BLANK;
        }
        char[] charBuff = new char[8];
        for (int i = 0; i < 8; ++i) {
            charBuff[i] = (char)this.byteBuff[i];
        }
        this.productID = new String(charBuff, 0, 8);
        return this.productID;
    }

    public String getSensorType() {
        int ret = this.getData(16, this.byteBuff, 8);
        if (ret != 0) {
            return this.BLANK;
        }
        char[] charBuff = new char[8];
        for (int i = 0; i < 8; ++i) {
            charBuff[i] = (char)this.byteBuff[i];
        }
        this.sensorType = new String(charBuff, 0, 8);
        return this.sensorType;
    }

    public void setAddress(int addr) {
        this.address = addr;
    }

    public I2CPort getPort() {
        return this.port;
    }
}

