/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import lejos.nxt.SystemSettings;

public class Sound {
    private static final int RIFF_HDR_SIZE = 44;
    private static final int RIFF_RIFF_SIG = 1380533830;
    private static final int RIFF_WAVE_SIG = 1463899717;
    private static final int RIFF_FMT_SIG = 1718449184;
    private static final short RIFF_FMT_PCM = 256;
    private static final short RIFF_FMT_1CHAN = 256;
    private static final short RIFF_FMT_8BITS = 2048;
    private static final int RIFF_DATA_SIG = 1684108385;
    public static final int VOL_MAX = 100;
    public static final String VOL_SETTING = "lejos.volume";
    public static final int[] PIANO = new int[]{4, 25, 500, 7000, 5};
    public static final int[] FLUTE = new int[]{10, 25, 2000, 1000, 25};
    public static final int[] XYLOPHONE = new int[]{1, 8, 3000, 5000, 5};
    private static int masterVolume = 0;
    public static int C2;

    private Sound() {
    }

    public static void systemSound(boolean aQueued, int aCode) {
        if (aCode == 0) {
            Sound.playTone(600, 200);
        } else if (aCode == 1) {
            Sound.playTone(600, 150);
            Sound.pause(200);
            Sound.playTone(600, 150);
            Sound.pause(150);
        } else if (aCode == 2) {
            for (int i = 4; i < 8; ++i) {
                Sound.playTone(C2 * i / 4, 100);
                Sound.pause(100);
            }
        } else if (aCode == 3) {
            for (int i = 7; i > 3; --i) {
                Sound.playTone(C2 * i / 4, 100);
                Sound.pause(100);
            }
        } else if (aCode == 4) {
            Sound.playTone(100, 500);
            Sound.pause(500);
        }
    }

    public static void beep() {
        Sound.systemSound(true, 0);
    }

    public static void twoBeeps() {
        Sound.systemSound(true, 1);
    }

    public static void beepSequence() {
        Sound.systemSound(true, 3);
    }

    public static void beepSequenceUp() {
        Sound.systemSound(true, 2);
    }

    public static void buzz() {
        Sound.systemSound(true, 4);
    }

    public static void pause(int t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static native int getTime();

    static native void playFreq(int var0, int var1, int var2);

    public static void playTone(int aFrequency, int aDuration, int aVolume) {
        aVolume = aVolume >= 0 ? aVolume * masterVolume / 100 : -aVolume;
        Sound.playFreq(aFrequency, aDuration, aVolume);
    }

    public static void playTone(int freq, int duration) {
        Sound.playTone(freq, duration, masterVolume);
    }

    static native void playSample(int var0, int var1, int var2, int var3, int var4);

    public static int playSample(File file, int vol) {
        if (file.length() < 44) {
            return -1;
        }
        FileInputStream f = new FileInputStream(file);
        DataInputStream d = new DataInputStream(f);
        int sampleRate = 0;
        int dataLen = 0;
        try {
            if (d.readInt() != 1380533830) {
                return -1;
            }
            d.readInt();
            if (d.readInt() != 1463899717) {
                return -1;
            }
            if (d.readInt() != 1718449184) {
                return -1;
            }
            d.readInt();
            if (d.readShort() != 256) {
                return -1;
            }
            if (d.readShort() != 256) {
                return -1;
            }
            sampleRate = d.readByte() & 0xFF;
            sampleRate |= (d.readByte() & 0xFF) << 8;
            sampleRate |= (d.readByte() & 0xFF) << 16;
            sampleRate |= (d.readByte() & 0xFF) << 24;
            d.readInt();
            d.readShort();
            if (d.readShort() != 2048) {
                return -1;
            }
            if (d.readInt() != 1684108385) {
                return -1;
            }
            dataLen = d.readByte() & 0xFF;
            dataLen |= (d.readByte() & 0xFF) << 8;
            dataLen |= (d.readByte() & 0xFF) << 16;
            d.close();
        }
        catch (IOException e) {
            return -1;
        }
        vol = vol >= 0 ? vol * masterVolume / 100 : -vol;
        Sound.playSample(file.getPage(), 44, dataLen |= (d.readByte() & 0xFF) << 24, sampleRate, vol);
        return Sound.getTime();
    }

    public static int playSample(File file) {
        return Sound.playSample(file, masterVolume);
    }

    static int waitUntil(int t) {
        int t2;
        while ((t2 = (int)System.currentTimeMillis()) < t) {
            Thread.yield();
        }
        return t2;
    }

    public static void playNote(int[] inst, int freq, int len) {
        int i;
        int segLen = inst[0];
        int step = 8000 / segLen;
        int vol = 2000;
        int t = Sound.waitUntil((int)System.currentTimeMillis() + 1);
        len /= 2;
        for (i = 0; i < segLen; ++i) {
            Sound.playTone(freq, 10, vol / 100);
            vol += step;
            t = Sound.waitUntil(t + 2);
        }
        len -= segLen;
        segLen = inst[1];
        if (segLen > 0) {
            step = inst[2] / segLen;
            for (i = 0; i < segLen; ++i) {
                Sound.playTone(freq, 100, vol / 100);
                vol -= step;
                t = Sound.waitUntil(t + 2);
            }
            len -= segLen;
        }
        if ((len -= (segLen = inst[4])) > 0) {
            step = inst[3] / len;
            for (i = 0; i < len; ++i) {
                Sound.playTone(freq, 100, vol / 100);
                vol -= step;
                t = Sound.waitUntil(t + 2);
            }
        } else {
            segLen += len;
        }
        if (segLen > 0) {
            step = (vol - 1000) / segLen;
            for (i = 0; i < segLen; ++i) {
                Sound.playTone(freq, 2, vol / 100);
                vol -= step;
                t = Sound.waitUntil(t + 2);
            }
        }
    }

    public static void setVolume(int vol) {
        if (vol > 100) {
            vol = 100;
        }
        if (vol < 0) {
            vol = 0;
        }
        masterVolume = vol;
    }

    public static int getVolume() {
        return masterVolume;
    }

    public static void loadSettings() {
        masterVolume = SystemSettings.getIntSetting(VOL_SETTING, 80);
    }

    static {
        Sound.loadSettings();
        C2 = 523;
    }
}

