/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import lejos.nxt.I2CPort;
import lejos.nxt.I2CSensor;

public class TiltSensor
extends I2CSensor {
    byte[] buf = new byte[2];
    byte[] buf2 = new byte[1];
    private static final String MINDSENSORS_ID = "mndsnsrs";
    private static byte X_TILT = (byte)66;
    private static byte Y_TILT = (byte)67;
    private static byte Z_TILT = (byte)68;
    private static byte MINDSTORMS_X_ACCEL_LSB = (byte)69;
    private static byte MINDSTORMS_Y_ACCEL_LSB = (byte)71;
    private static byte MINDSTORMS_Z_ACCEL_LSB = (byte)73;
    private static byte HITECHNIC_X_ACCEL_2BITS = (byte)69;
    private static byte HITECHNIC_Y_ACCEL_2BITS = (byte)70;
    private static byte HITECHNIC_Z_ACCEL_2BITS = (byte)71;
    private boolean isMindsensors;

    public TiltSensor(I2CPort port) {
        super(port);
        port.setType(11);
        this.isMindsensors = this.getProductID().equals(MINDSENSORS_ID);
    }

    public int getXTilt() {
        int ret = this.getData(X_TILT, this.buf, 1);
        return ret == 0 ? this.buf[0] & 0xFF : -1;
    }

    public int getYTilt() {
        int ret = this.getData(Y_TILT, this.buf, 1);
        return ret == 0 ? this.buf[0] & 0xFF : -1;
    }

    public int getZTilt() {
        int ret = this.getData(Z_TILT, this.buf, 1);
        return ret == 0 ? this.buf[0] & 0xFF : -1;
    }

    public int getXAccel() {
        if (this.isMindsensors) {
            int ret = this.getData(MINDSTORMS_X_ACCEL_LSB, this.buf, 2);
            int accel = this.buf[0] & 0xFF | this.buf[1] << 8;
            return ret == 0 ? accel : -1;
        }
        int ret = this.getData(X_TILT, this.buf, 1);
        if (ret != 0) {
            return -1;
        }
        ret = this.getData(HITECHNIC_X_ACCEL_2BITS, this.buf2, 1);
        if (ret != 0) {
            return -1;
        }
        return ((this.buf[0] & 0xFF) << 2) + (this.buf2[0] & 0xFF);
    }

    public int getYAccel() {
        if (this.isMindsensors) {
            int ret = this.getData(MINDSTORMS_Y_ACCEL_LSB, this.buf, 2);
            int accel = this.buf[0] & 0xFF | this.buf[1] << 8;
            return ret == 0 ? accel : -1;
        }
        int ret = this.getData(Y_TILT, this.buf, 1);
        if (ret != 0) {
            return -1;
        }
        ret = this.getData(HITECHNIC_Y_ACCEL_2BITS, this.buf2, 1);
        if (ret != 0) {
            return -1;
        }
        return ((this.buf[0] & 0xFF) << 2) + (this.buf2[0] & 0xFF);
    }

    public int getZAccel() {
        if (this.isMindsensors) {
            int ret = this.getData(MINDSTORMS_Z_ACCEL_LSB, this.buf, 2);
            int accel = this.buf[0] & 0xFF | this.buf[1] << 8;
            return ret == 0 ? accel : -1;
        }
        int ret = this.getData(Z_TILT, this.buf, 1);
        if (ret != 0) {
            return -1;
        }
        ret = this.getData(HITECHNIC_Z_ACCEL_2BITS, this.buf2, 1);
        if (ret != 0) {
            return -1;
        }
        return ((this.buf[0] & 0xFF) << 2) + (this.buf2[0] & 0xFF);
    }
}

