/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.DebugLog;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class UtilsJavaSE {
    static final boolean javaSECompiledOut = false;
    static boolean java13 = false;
    static boolean java14 = false;
    static final boolean ibmJ9midp = UtilsJavaSE.detectJ9midp();

    private UtilsJavaSE() {
    }

    private static boolean detectJ9midp() {
        String ibmJ9config;
        try {
            ibmJ9config = System.getProperty("com.ibm.oti.configuration");
        }
        catch (SecurityException webstart) {
            return false;
        }
        return ibmJ9config != null && ibmJ9config.indexOf("midp") != -1;
    }

    static StackTraceLocation getLocation(Vector fqcnSet) {
        if (java13 || ibmJ9midp) {
            return null;
        }
        if (!java14) {
            try {
                Class.forName("java.lang.StackTraceElement");
                java14 = true;
                DebugLog.debug("Java 1.4+ detected");
            }
            catch (ClassNotFoundException e) {
                java13 = true;
                return null;
            }
        }
        try {
            return UtilsJavaSE.getLocationJava14(fqcnSet);
        }
        catch (Throwable e) {
            java13 = true;
            return null;
        }
    }

    private static StackTraceLocation getLocationJava14(Vector fqcnSet) {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        for (int i = 0; i < ste.length - 1; ++i) {
            String nextClassName;
            if (!fqcnSet.contains(ste[i].getClassName()) || (nextClassName = ste[i + 1].getClassName()).startsWith("java.") || nextClassName.startsWith("sun.") || fqcnSet.contains(nextClassName)) continue;
            StackTraceElement st = ste[i + 1];
            StackTraceLocation loc = new StackTraceLocation();
            loc.className = st.getClassName();
            loc.methodName = st.getMethodName();
            loc.fileName = st.getFileName();
            loc.lineNumber = st.getLineNumber();
            return loc;
        }
        return null;
    }

    public static void threadSetDaemon(Thread thread) {
        try {
            if (!ibmJ9midp) {
                thread.setDaemon(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void runtimeAddShutdownHook(Thread thread) {
        try {
            if (!ibmJ9midp) {
                Runtime.getRuntime().addShutdownHook(thread);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void setSystemProperty(String propertyName, String propertyValue) {
        if (ibmJ9midp) {
            return;
        }
        boolean propertySet = false;
        try {
            Properties props = System.getProperties();
            if (propertyValue != null) {
                ((Hashtable)props).put(propertyName, propertyValue);
                propertySet = propertyValue.equals(System.getProperty(propertyName));
            } else {
                ((Hashtable)props).remove(propertyName);
                propertySet = System.getProperty(propertyName) == null;
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (!propertySet) {
            try {
                if (propertyValue != null) {
                    System.setProperty(propertyName, propertyValue);
                } else {
                    System.clearProperty(propertyName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static class StackTraceLocation {
        public String className;
        public String methodName;
        public String fileName;
        public int lineNumber;

        StackTraceLocation() {
        }
    }
}

