/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.obex.OBEXServerSessionImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.HeaderSet;
import javax.obex.Operation;

abstract class OBEXServerOperation
implements Operation {
    protected OBEXServerSessionImpl session;
    protected HeaderSet receivedHeaders;
    protected HeaderSet sendHeaders;
    protected boolean isClosed = false;
    protected boolean finalPacketReceived = false;

    protected OBEXServerOperation(OBEXServerSessionImpl session, HeaderSet receivedHeaders) {
        this.session = session;
        this.receivedHeaders = receivedHeaders;
    }

    abstract void writeResponse(int var1) throws IOException;

    public void abort() throws IOException {
        throw new IOException("Can't abort server operation");
    }

    public HeaderSet getReceivedHeaders() throws IOException {
        return this.receivedHeaders;
    }

    public int getResponseCode() throws IOException {
        throw new IOException("Operation object was created by an OBEX server");
    }

    public void sendHeaders(HeaderSet headers) throws IOException {
        this.sendHeaders = headers;
    }

    public String getEncoding() {
        return null;
    }

    public long getLength() {
        Long len;
        try {
            len = (Long)this.receivedHeaders.getHeader(195);
        }
        catch (IOException e) {
            return -1L;
        }
        if (len == null) {
            return -1L;
        }
        return len;
    }

    public String getType() {
        try {
            return (String)this.receivedHeaders.getHeader(66);
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public abstract /* synthetic */ InputStream openInputStream() throws IOException;

    public abstract /* synthetic */ OutputStream openOutputStream() throws IOException;
}

