/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import js.tinyvm.Binary;
import js.tinyvm.ClassRecord;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.JavaClass;

public class ExceptionRecord
implements WritableData {
    CodeException iExcep;
    ClassRecord iClassRecord;
    Binary iBinary;

    public ExceptionRecord(CodeException aExcep, Binary aBinary, JavaClass aCF) throws Exception {
        this.iExcep = aExcep;
        int pCPIndex = aExcep.getCatchType();
        if (pCPIndex == 0) {
            this.iClassRecord = aBinary.getClassRecord("java/lang/Throwable");
        } else {
            ConstantClass pCls = (ConstantClass)aCF.getConstantPool().getConstant(pCPIndex);
            String pName = pCls.getBytes(aCF.getConstantPool());
            this.iClassRecord = aBinary.getClassRecord(pName);
        }
        if (this.iClassRecord == null) {
            throw new TinyVMException("Exception not found: " + this.iExcep);
        }
        this.iClassRecord.markUsed();
        this.iBinary = aBinary;
    }

    public int getLength() {
        return IOUtilities.adjustedSize(7, 2);
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        int pStart = this.iExcep.getStartPC();
        int pEnd = this.iExcep.getEndPC();
        int pHandler = this.iExcep.getHandlerPC();
        int pClass = this.iBinary.getClassIndex(this.iClassRecord);
        if (pStart > 65535 || pEnd > 65535 || pHandler > 65535) {
            throw new TinyVMException("Exception handler with huge PCs");
        }
        if (pClass < 0) {
            throw new TinyVMException("Exception class record missing");
        }
        try {
            aOut.writeU2(pStart);
            aOut.writeU2(pEnd);
            aOut.writeU2(pHandler);
            aOut.writeU1(pClass);
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean equals(Object aOther) {
        if (!(aOther instanceof ExceptionRecord)) {
            return false;
        }
        return ((ExceptionRecord)aOther).iExcep.equals(this.iExcep);
    }

    public int hashCode() {
        return this.iExcep.hashCode();
    }
}

