/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "platform.h"
#include "commontypes.h"
#include "DeviceAdapter/FirmwareUpdate/IFirmwareUpdater.h"

#ifdef PLATFORM_LINUX
	#define DEVICE_ADAPTER_API
#elif defined(PLATFORM_WINDOWS)
	#ifdef DEVICE_ADAPTER_EXPORTS
		#define DEVICE_ADAPTER_API __declspec(dllexport)
	#else
		#define DEVICE_ADAPTER_API __declspec(dllimport)
	#endif // DEVICE_ADAPTER_EXPORTS
#else
	#define DEVICE_ADAPTER_API
#endif


namespace NS_DM_Client
{
	class DevInfo;
	class DevDetail;
	class DMAcc;
	class WiMAX;
	class WiMAXSupp;
	class IDaemonEngineRequest;

	typedef unsigned char byte;

	class IDeviceAdapter
	{
	public:
		virtual ~IDeviceAdapter() {}

		/// Initialize adapter
		virtual bool Init(const StringMap& settings, IDaemonEngineRequest* request = 0) = 0;
		/// Release adapter
		virtual void Release() = 0;

		/// Open the device
		virtual bool Open() = 0;
		/// Close the device
		virtual bool Close() = 0;

		//
		// MO tree API
		//
		virtual bool GetDeviceInfo(DevInfo& deviceInfo) = 0;
		virtual bool GetDeviceDetail(DevDetail& deviceDetail) = 0;
		virtual bool GetDMAccount(DMAcc& dmAccount) = 0;
		virtual bool GetWiMAX(WiMAX& wimax) = 0;
		virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp) = 0;

		virtual bool SetDeviceInfo(const DevInfo& deviceInfo) = 0;
		virtual bool SetDeviceDetail(const DevDetail& deviceDetail) = 0;
		virtual bool SetDMAccount(const DMAcc& dmAccount) = 0;
		virtual bool SetWiMAX(const WiMAX& wimax) = 0;
		virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp) = 0;

		//virtual bool Set
		//
		// Firmware update (FUMO) API
		//
		typedef IFirmwareUpdater::EnumFirmwareStatus	EnumFirmwareStatus;
		virtual EnumFirmwareStatus InitFirmwareStorage(const char* packageName = 0, const char* location = 0) = 0;
		virtual EnumFirmwareStatus ResetFirmwareStorage() = 0;
		virtual EnumFirmwareStatus AppendFirmwareChunk(const char* buffer, size_t size, bool last) = 0;
		virtual EnumFirmwareStatus UpdateFirmware() = 0;

		/// Set/Get Extended Master Session Key
		virtual bool SetEMSK(const void*, size_t size) = 0;
		virtual bool GetEMSK(void*, size_t& size) = 0;

		/// Set/Get device network identifier (e.g. MAC address)
		virtual bool SetDeviceID(const String& deviceID) = 0;
		virtual bool GetDeviceID(String& deviceID) = 0;

		/// Set/Get device manufacturer
		virtual bool SetManufacturer(const String& manufacturer) = 0;
		virtual bool GetManufacturer(String& manufacturer) = 0;

		/// Set/Get device model
		virtual bool SetModel(const String& model) = 0;
		virtual bool GetModel(String& model) = 0;

		/// Get network interface name assigned for the device in the system
		virtual bool GetNetworkInterfaceName(char*, size_t& size) = 0;

	};

	static const char EMSKSourceParam[] = "EMSKSource";

	static const char FirmwareDefaultLocationParam[] = "FirmwareDefaultLocation";
	static const char FirmwarePackageDefaultNameParam[] = "FirmwarePackageDefaultName";
	static const char FirmwareStorageNoCleanParam[] = "FirmwareStorageNoClean";
	static const char FirmwareUpdateResultParam[] = "FirmwareUpdateResult";

	static const char DeviceIDParam[] = "DeviceID";
	static const char NetworkIFParam[] = "NetworkIF";
}

extern "C" DEVICE_ADAPTER_API NS_DM_Client::IDeviceAdapter* CreateDeviceAdapter(void* param);
