/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <NotificationListener/NotificationMessage.h>

namespace NS_DM_Client
{

    namespace NS_NotificationListener
    {
        typedef NotificationMessage::EnumUIMode     EnumUIMode;
        class SessionInfo
        {
        public:
            /// 'true' if session is initiated by server, 'false' if session is initiated by client (user or DM Client itself)
            bool    serverInitiated;

            /// UI interaction mode
            EnumUIMode uiMode;

            /// session id
            String  sessionID;

            /// server id
            String  serverID;

            SessionInfo()
            : serverInitiated(false),
            uiMode(NotificationMessage::e_UI_NotDefined)
            {}

        };

    }
}

