/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "common/commontypes.h"

namespace NS_DM_Client
{


class IConfigurationParser
{
public:
    enum ConfigurationParserType
    {
        e_XML = 0
    };

    IConfigurationParser() { }
    virtual ~IConfigurationParser() { }

    static IConfigurationParser* GetInstance(ConfigurationParserType type);

    virtual void Release() = 0;

    virtual bool Init(const char* configuration, const char* group = 0) = 0;
    virtual bool Init(const String& configuration, const char* group = 0);
    virtual bool GetProperty(const String& name, String& value) = 0;

private:

    IConfigurationParser(const IConfigurationParser&);
    IConfigurationParser& operator =(const IConfigurationParser&);
};

}
