/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "commontypes.h"
#include "platform.h"
#include <syncml/core/NextNonce.h>
#include <syncml/core/Item.h>

namespace NS_DM_Client
{
#define __MIN(a, b)	( ((a) > (b)) ? (b) : (a) )

	Funambol::NextNonce * CreateNonce();
	bool IsBooleanTrue(const String &value);
	void PrintMessage(const char * logger, const char * prefix, const char * msg);
	String ToString(int value);
	
#if defined(PLATFORM_POSIX)
	#define __strcpy strcpy
	#define __strncpy strncpy
	#define __sprintf sprintf
#elif defined(PLATFORM_WINDOWS)
	#define __strcpy(dest, src) strcpy_s((dest), INT_MAX, (src))
	#define __strncpy(dest, src, size) strncpy_s((dest), INT_MAX, (src), (size))
	#define __sprintf(dest, ...) sprintf_s((dest), INT_MAX,##__VA_ARGS__)
#endif

#if !defined(PLATFORM_WINDOWS)
	#define strcpy_s(buf, buf_size, ...) strcpy((buf), ##__VA_ARGS__)
	#define strncpy_s(buf, buf_size, ...) strncpy((buf), ##__VA_ARGS__)
	#define sprintf_s(buf, buf_size, ...)	sprintf((buf), ##__VA_ARGS__)
#endif

	bool __fopen(const char* name, const char* mode, FILE*& file);

	void trim(String &);

	class Utils
	{
	public:
		/// Buffer to ASCII hexadecimal sting conversion routine.
		/// @param byteSeparator defines separator character. If it is '\0' separator is not used. Default is space (' ') character.
		static const char* ToAsciiHex(String& dest, const void* data, size_t dataSize, char byteSeparator = ' ');
		
		static void ConstructItem(Funambol::Item &, const URI &target, cstr data);
		static void ConstructItem(Funambol::Item &, const URI &target, cstr data, cstr format, cstr typ);
	};
	
}
