/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <map>
#include "commontypes.h"

#define MIME_OMA_DD "application/vnd.oma.dd+xml"

namespace NS_DM_Client
{
	namespace NS_Common
	{
		/*
		 * Abstract class that is capable of downloading file from the remote host by the specified URL.
		 */
		class Downloader
		{
		public:
			typedef enum {
				DS_FINISHED = 0,
				DS_NOT_INITIALIZED,
				DS_MALFORMED_URL,
				DS_FAILED,
				DS_NO_FREE_DISK_SPACE
			} DownloadStatus;

		public:
			Downloader();
			Downloader(const char *URL);
			virtual ~Downloader();

			// Set secondary downloader to handle data
			void SetDownloader(Downloader *pd) { m_pDownloader = pd; };

			// Start download
			// Returned value indicates download status
			virtual DownloadStatus Download() = 0;

			// Return implementation specific error code
			int GetLastError() { return m_error; };

		protected:
			typedef std::map<String, String> Properties;

			int          m_error;
			char       * m_url;
			Downloader * m_pDownloader;
			Properties   m_properties;

			/** set property read from the http header */
			virtual void setProperty(const char *, const char *);
			
			/** store received data. Return number of written bytes */
			virtual int  storeBuffer(void *buffer, uint size);
		};


		class DownloaderFactory
		{
		public:
			/**
			 * Create downloader instance.
			 * Returned object should be freed by the caller.
			 */
			static Downloader * CreateDownloader(const char *URL);

		private:
			DownloaderFactory();
			DownloaderFactory(const DownloaderFactory&);
		};
	}
}


