/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <pthread.h>

namespace NS_DM_Client
{
	namespace NS_Common
	{
		/// Class represents a critical section sync object
		class CritSection
		{
		public:
			CritSection()  {	pthread_mutex_init(&m_mutex, NULL);		}
			~CritSection() {	pthread_mutex_destroy(&m_mutex);		}

			void Lock()    {	pthread_mutex_lock(&m_mutex);			}
			int  TryLock() {	return pthread_mutex_trylock(&m_mutex);		} // return 0 on success
			void Unlock()  {	pthread_mutex_unlock(&m_mutex);			}

			friend class CondVariable;

		private:
			pthread_mutex_t m_mutex;
		};
	}
}

