/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "platform.h"
#include "DaemonDM/IPCExchangeDefs.h"
#include "common/Buffer.h"
#include "common/Errors.h"


#ifdef PLATFORM_LINUX
#define DM_ENGINE_API
#elif defined(PLATFORM_WINDOWS)
#ifdef DM_ENGINE_EXPORTS
#define DM_ENGINE_API __declspec(dllexport)
#else
#define DM_ENGINE_API __declspec(dllimport)
#endif // DM_ENGINE_EXPORTS
#else
#define DM_ENGINE_API 
#endif

namespace NS_DM_Client
{
	class DM_ENGINE_API IDaemonEngine
	{
	public:
		virtual ~IDaemonEngine(){}

		virtual bool Start() = 0;
		virtual bool Stop() = 0;

		static IDaemonEngine*	GetInstance();
		virtual void Release() = 0;		
		
		virtual StatusCode HandleClientRequest(const UIMessageType& type, const Buffer& input, StatusCode& res, Buffer& output) = 0;

	protected:
		IDaemonEngine();
	private:
		IDaemonEngine(IDaemonEngine&);
		IDaemonEngine& operator = (IDaemonEngine&);
	};

}
