/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

namespace NS_DM_Client
{
	class IDaemonEngineRequest
	{
	public:
		virtual ~IDaemonEngineRequest() {};

		/// issue Check FUMO Update request to the server
		virtual void CheckFUMOUpdate() = 0;


		enum EnumDeviceStatus
		{
			e_DeviceStatusUnknown = 0,

			e_DeviceAttached,
			e_DeviceDetached
		};

		/// notifies that the device status is changed
		virtual void DeviceStatusChanged(EnumDeviceStatus newStatus) = 0;

		enum EnumNetworkStatus
		{
			e_NetworkStatusUnknown = 0,

			e_EnteredNetwork,
			e_LeftNetwork,

			// network address is changed (e.g. IP-address is assgned)
			e_NetworkAddressAssigned,
			e_NetworkAddressClear
		};

		/// notifies that network status is chnaged (e.g. device is registered in the network)
		virtual void NetworkStatusChanged(EnumNetworkStatus newStatus) = 0;

	};
}
