/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

namespace NS_DM_Client
{
    class MOTreeCommand;
    class ServerExchangeCommand;

    namespace NS_ExecutionQueue
    {
        class ICommandsQueue;
        class MOTreeCommandsQueue;
        class ServerExchangeCommandsQueue;

        class CommandQueuePool
        {
        public:
            CommandQueuePool(
                MOTreeCommandsQueue& MOTreeCmdQ,
                ServerExchangeCommandsQueue& ServXchgCmdQ
                );
            ~CommandQueuePool();

            ICommandsQueue& GetMOTreeCmdQueue();
            ICommandsQueue& GetServerExchangeCmdQueue();

            bool            StopCommandQueues();

        private:
            ICommandsQueue&  m_MOTreeCmdQ;
            ICommandsQueue&  m_ServXchgCmdQ;
        };

    }

}
