/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <executionqueue/IExecutionQueue.h>
#include <executionqueue/CommandQueuePool.h>

#include <Logger/Logger.h>

namespace NS_DM_Client
{
    namespace NS_ExecutionQueue
    {
        class CommandQueuePool;
        class QueueCommandRouter;

        class ExecutionQueue : public IExecutionQueue
        {
        public:
            ExecutionQueue(void);
            virtual ~ExecutionQueue(void);

            virtual bool Init(const StringMap& settings, const String& loggerInstance, ProfileComponentsHolder& pch);
            virtual void Release();

            virtual bool Start();
            virtual bool Stop();

            virtual bool Add(ICommand& cmd);

        private:
            bool    isInitialized() const;

        private:
            NS_Logging::Logger*     m_logger;

            CommandQueuePool*       m_QPool;
            QueueCommandRouter*     m_CmdDispatcher;
        };

    }
}
