/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <spds/CredentialHandler.h>
#include <spds/SyncMLBuilder.h>
#include "commontypes.h"
#include "serverexchange/wrappers/SCommandAdapter.h"
#include "serverexchange/ConnectionInfo.h"

namespace NS_DM_Client
{
	namespace NS_Communication
	{
		///
		class MessageFactory
		{
		public:
			MessageFactory(ConnectionInfo &);
			~MessageFactory();
			
			int  AddCommand(NS_SyncMLCommand::SCommandPtr);
			int  AddCommand(ResultsPtr);

			int  MessageSizeWithoutBody(bool includeFinal = true);
			void ResetCommands();
			
			/// Creates syncml message using passed connection info and added commands.
			/// Caller becames owner of the returned object.
			FStringBuffer * GetMessage(bool includeFinal = true);

		private:
			int m_commandNumber;

			ConnectionInfo              & m_connInfo;
			Funambol::Cred              * m_pCred;
			Funambol::CredentialHandler   m_credentialHandler;
			FStringBuffer               * m_pMessageBody;
			Funambol::SyncHdr           * m_pSyncHdr;
			Funambol::SyncMLBuilder     * m_pSyncMLBuilder;

			void            createHeader();
			static FStringBuffer * createXML(FStringBuffer *pHeader, FStringBuffer *pMessageBody, bool addFinal = false);
			static unsigned int    getMsgServiceInfoSize(bool includeFinal = true);
			void            prepareCredentials();

			MessageFactory();
			MessageFactory(const MessageFactory&);
			const MessageFactory & operator= (const MessageFactory &);
		};
	}
}
