/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <syncml/core/ItemizedCommand.h>
#include <syncml/core/SyncML.h>
#include <syncml/core/Add.h>
#include <syncml/core/Alert.h>
#include <syncml/core/Atomic.h>
#include <syncml/core/Copy.h>
#include <syncml/core/Delete.h>
#include <syncml/core/Exec.h>
#include <syncml/core/Get.h>
#include <syncml/core/Replace.h>
#include <syncml/core/Results.h>
#include <syncml/core/Sequence.h>
#include <syncml/core/Status.h>

#include "ConnectionInfo.h"
#include "treemanager/ActionCommand.h"
#include "serverexchange/ICommandsSink.h"
#include "serverexchange/session/ISession.h"
#include "serverexchange/wrappers/CommandsSinkHolder.h"


namespace NS_DM_Client
{
	namespace NS_Communication
	{
		class LOCollector;
		class Connection;
		
		/// Class implements processing of the SyncML DM message. XML document is parsed by the internals
		/// of the Funambol SDK. Corresponding processor is created for every command received from server.
		/// Receiving of LO is implemented as well.
		class ResponseProcessor : public NS_SyncMLCommand::CommandsSinkHolder
		{
		public:
			typedef enum {
				PS_Successful,
				PS_MalformedMessage,
				PS_InvalidServerCred,
				PS_InvalidParam
			} ProcessingStatus;

		public:

			ResponseProcessor(ConnectionInfo &, NS_SyncMLCommand::ICommandsSink *, ProfileComponentsHolder *);
			~ResponseProcessor();

			ProcessingStatus Process(const char * xmlresponse, bool sumode = false);

			bool LastResponseFound()                { return m_sessionFinished; };
			void SetSession(ISession &s)            { m_pSession = &s;	        };
			void SetCheckForCred(bool check)        { m_checkForCred = check;   };
			void SetPCH(ProfileComponentsHolder &p) { m_pPCH = &p;              };
			
		private:
			bool                     m_sessionFinished;
			bool                     m_checkForCred;
			bool                     m_changeAuthType;
			char                    *m_cServerID;
			unsigned int             m_responseCommandsCount;
			
			// TODO - do not store local copy
			ConnectionInfo          *m_pConnInfo;
			ISession                *m_pSession;
			
			Funambol::SyncML        *m_pSyncML;
			LOCollector             *m_pLOCollector;
			ProfileComponentsHolder *m_pPCH;

			ResponseProcessor(const ResponseProcessor&);

			void checkForNextChunkData();
			bool commandHasLOChunk(Funambol::ItemizedCommand *cmd);

			void enqueueExCommand    (ActionCommand &);
			void processHeader    ();
			void processCommand	  (Funambol::AbstractCommand *cmd); 

			void processAdd       (Funambol::Add      *cmd);
			void processAtomic    (Funambol::Atomic   *cmd);
			void processCopy      (Funambol::Copy     *cmd);
			void processDelete    (Funambol::Delete   *cmd);
			void processExec      (Funambol::Exec     *cmd);
			void processGet       (Funambol::Get      *cmd);
			void processReplace   (Funambol::Replace  *cmd);

			void processAlert     (Funambol::Alert    *cmd);
			void processResults   (Funambol::Results  *cmd);
			void processSequence  (Funambol::Sequence *cmd);
			void processStatus    (Funambol::Status   *cmd);

			int  processLOChunk   (Funambol::ItemizedCommand &cmd);
			void initProcessing   (bool sumode, int commandsCount);
		};
	}
}

