/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "treemanager/ActionCommand.h"

namespace NS_DM_Client
{
	class IMOTreeManager;

	class MOTreeGetCommand : public ActionCommand
	{
	public:
		MOTreeGetCommand(ProfileComponentsHolder* prholder,
						 GetPtr& command,
						 const String& msgID,
						 const char* serverId = 0);
		virtual ~MOTreeGetCommand(void);

		virtual bool Execute();
		void SetMaxObjSize(unsigned int size) { m_maxObjSize = size; };

	protected:
        virtual Funambol::ArrayList* getListOfItems();

		unsigned int m_maxObjSize;
		GetPtr m_GetCommand;

		virtual MOTreeResponseCommand * CreateResponse();

    private:
		StatusCode performListExecution(Funambol::ArrayList &items, const URI uri, size_t pos, const char* serverId = 0);

		MOTreeGetCommand(const MOTreeGetCommand&);
		MOTreeGetCommand& operator =(const MOTreeGetCommand&);

		StatusCode performOperation();
        StatusCode processGetOnItems(Funambol::ArrayList* items);
    };
}
