#include "Utils.h"
#include <android/log.h>

#define printf(...) __android_log_print(ANDROID_LOG_DEBUG, "TestClientAdapterUtils", __VA_ARGS__);

namespace NS_DM_Client
{
	void GetContent(FILE* file, String& line)
	{
		char c;
		do 
		{
			c = fgetc(file);
			if (c != EOF)
				line += c;
			else
				break;
		}
		while (c != EOF);
	}
	//-------------------------------------------------------------------------------------------

	void ReadFromFile(const char* fileName, String& content)
	{
		FILE* file = fopen(fileName, "r");
		if (!file)
		{
			printf("ERROR: Cannot open file \"%s\"", fileName);
			return;
		}

 		GetContent(file, content);
 		if (content.size() != 0)
		{
			printf("content was read from file, filename = %s", fileName);

			// remove last \n
			if (content[content.size() - 1] == '\n')
			{
				content.resize(content.size() - 1);
			}
		}
		else
		{
			printf("Nothing was read from file, filename = %s", fileName);
		}
	}
	//-------------------------------------------------------------------------------------------

// 	void ReadFromFile(const char* fileName, String& content)
// 	{
// 		std::ifstream expectedFile(fileName);
// 		String tmpContent;
// 		while (GetLine(expectedFile, tmpContent))
// 		{
// 			content += tmpContent + "\n";
// 		}
// 		if (content.size() != 0)
// 		{
// 			printf("content was read from file, filename = %s", fileName);
// 
// 			// remove last \n
// 			content.resize(content.size() - 1);
// 			//			expectedFile >> content;
// 		}
// 		else
// 		{
// 			printf("Nothing was read from file, filename = %s", fileName);
// 		}
// 	}
	//-------------------------------------------------------------------------------------------
}
