/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "DaemonDM/IMessageHandler.h"
#include "Event.h"
#include "CritSection.h"

namespace NS_DM_Client
{
	class IRequestHandler;
	
	class RequestMessageHandler : public IMessageHandler
	{
	public:
		RequestMessageHandler(IRequestHandler* requestHandler = 0);
		virtual ~RequestMessageHandler();

		virtual bool Init();
		virtual bool Release();

		virtual StatusCode Display(const char* message, long min_time, long max_time);
		virtual StatusCode Confirmation(const char* message, long min_time, long max_time);
		virtual StatusCode UserInput(const char* message, long min_time, long max_time, char*& input,
			long max_len = 0, bool echo_password = 0);
		virtual StatusCode UserChoice(const char* message, long min_time, long max_time,
			const char* avialable_choise_set, char*& choise_set, bool allowMultipleChoises);
		virtual StatusCode ProgressNotification(const char* message, long min_time, long max_time,
			long size_to_download);

		virtual void ReleaseString(char* str);

	private:
		IRequestHandler* m_requestHandler;
		NS_Common::Event m_waitEvent;
		NS_Common::CritSection m_critSection;
	};
}

