/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "commontypes.h"
#include "daemon/INotification.h"

namespace NS_DM_Client
{
	struct Message;
	typedef unsigned char byte;

	class MessageDeserializer
	{
	public:
		MessageDeserializer();

		void operator()(void* data, size_t size, Message& message);

	private:
		void retrieve(void*& data, size_t& result);
		void retrieve(void*& data, String& result);
		void retrieve(void*& data, std::vector<byte>& result);
	};
	//-------------------------------------------------------------------------------------------

	void DeserializeOperatorProfile(const String& data, String& name, String& type, String& description);
	void DeserializeConfirmationResponse(const String& data, String& messageRequest, size_t& confCode);
	void DeserializeDMSessionNotification(const String& data, EventType& eventType, Initiator& initiator, NotificationStatus& statusCode);
	void DeserializeFirmwareInfo(const String& data, String& localpath, String& filename, int& size);
	void DeserializePasswords(const String& data, String& oldPassword, String& newPassword);
	void DeserializePasswordsAndServerID(const String& data, String& serverID, String& oldPassword, String& newPassword);
}
