#pragma once

#include "DaemonDM/IMessageHandler.h"


namespace NS_DM_Client
{
const size_t cMaxDefSize = 256;

class CUIMessageHandler : public IMessageHandler
{
public:
    CUIMessageHandler(
        const char* default_user_input,
        const char* default_user_confirm,
        const char* default_user_choise,
        bool* downloadCancel);

    virtual bool Init();
    virtual bool Release();

    virtual StatusCode Display(const char* message, long min_time, long max_time);
    virtual StatusCode Confirmation(const char* message, long min_time, long max_time);
    virtual StatusCode UserInput(const char* message, long min_time, long max_time, char*& input,
        long* max_len = 0, bool echo_password = 0);
    virtual StatusCode UserChoice(const char* message, long min_time, long max_time,
        const char* avialable_choise_set, char*& choise_set, bool allowMultipleChoises);
    virtual StatusCode ProgressNotification(const char* message, long min_time, long max_time,
        long size_to_download);

    virtual void ReleaseString(char* str);

    virtual ~CUIMessageHandler();

private:
    char m_defUserInput[cMaxDefSize];
    char m_defUserConfirm[2];
    char m_defUserChoise[cMaxDefSize];
    bool m_downloadCancel;
};


}
