#include "DaemonDM/ProfileManager.h"
#include "Logger/Logger.h"
#include "commontypes.h"
#include "IFIFOWrapper.h"
#include "MessengerDefs.h"

const char* const c_ProfileManagerLog = "ProfileManagerAPI";

namespace NS_DM_Client
{
//------------------------------------------------------------------------------------------------------
ProfileManager::ProfileManager()
    : m_fifo_request(0), m_fifo_response(0)
{
}
//------------------------------------------------------------------------------------------------------
void ProfileManager::release()
{
    if (m_fifo_request)
    {
        m_fifo_request->Release();
    }
    if (m_fifo_response)
    {
        m_fifo_response->Release();
    }
}
//------------------------------------------------------------------------------------------------------
ProfileManager::~ProfileManager()
{
    release();
}
//------------------------------------------------------------------------------------------------------
ProfileManager::ProfileManager(const ProfileManager&)
{
    #ifndef PLATFORM_ANDROID
        throw "error: trying to call copy constructor for ProfileManager";
    #else
        NULL;
    #endif
}
//------------------------------------------------------------------------------------------------------
ProfileManager& ProfileManager::operator=(const ProfileManager&)
{
    #ifndef PLATFORM_ANDROID
        throw "error: trying to call operator= for ProfileManager";
    #else
        NULL;
    #endif

    return *this;
}
//------------------------------------------------------------------------------------------------------
bool ProfileManager::Init()
{
    if (m_fifo_request && m_fifo_response)
    {
        return true;
    }

    m_fifo_request = 0;
    m_fifo_response = 0;

    m_fifo_request = CreateFIFOWrapper(false);
    if (!m_fifo_request)
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "can't create fifo request wrapper");
        return false;
    }

    if (!m_fifo_request->Open(c_IPCRequestFifoName, false, false, true))
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "can't open request fifo");
        m_fifo_request->Release();
        m_fifo_request = 0;
        return false;
    }

    m_fifo_response = CreateFIFOWrapper(false);
    if (!m_fifo_response)
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "can't create fifo responce wrapper");
        m_fifo_request->Release();
        m_fifo_request = 0;
        m_fifo_response->Release();
        m_fifo_response = 0;
        return false;
    }

    if (!m_fifo_response->Open(c_IPCResponseFifoName, true, false, true))
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "can't open response fifo");
        m_fifo_request->Release();
        m_fifo_request = 0;
        m_fifo_response->Release();
        m_fifo_response = 0;
        return false;
    }

    return true;
}
//------------------------------------------------------------------------------------------------------
bool ProfileManager::Release()
{
    if (!(m_fifo_request && m_fifo_response))
    {
        return true;
    }

    release();
    return true;
}
//------------------------------------------------------------------------------------------------------
StatusCode ProfileManager::FetchFirstProfileInfo(ProfileInfo& profile)
{
    StatusCode res = e_Failed;

    m_profiles.clear();
    m_profiles_index = 0;
    UIExchangeHead request_head;
    memset(&request_head, 0, sizeof(UIExchangeHead));
    request_head.m_type = e_GetProfiles;
    request_head.m_payload_size = 0;
    Buffer buffer(sizeof(request_head), '\0');
    memcpy(buffer.GetPointer(), &request_head, sizeof(request_head));

    if (m_fifo_request->Write(buffer) == e_Ok)
    {
        UIResponseExchangeHead response_head;
        buffer.Allocate(sizeof(response_head), '\0');
        if (m_fifo_response->Read(buffer) == e_Ok)
        {
            memset(&response_head, 0, sizeof(UIResponseExchangeHead));
            memcpy(&response_head, buffer.GetPointer(), buffer.Size());
            if (response_head.m_perform_code == e_Ok)
            {
                buffer.Allocate(response_head.m_payload_size, '\0');
                if (m_fifo_response->Read(buffer, true) == e_Ok)
                {
                    char* ptr = (char*)buffer.GetPointer();
                    size_t data_size;
                    ProfileInfo current_profile;

                    memset(&current_profile, 0, sizeof(ProfileInfo));
                    size_t index = 0;
                    while (index < response_head.m_payload_size)
                    {
                        // fetching profile name
                        data_size = *((size_t*)ptr);
                        current_profile.m_Name = (char*)malloc(data_size + 1);
                        if(current_profile.m_Name == NULL)
                        {
                            LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "malloc current_profile.m_Name");
                            return res;
                        }
                        index += sizeof(data_size);
                        ptr += sizeof(data_size);
                        memset(current_profile.m_Name, 0, data_size + 1);
                        memcpy(current_profile.m_Name, ptr, data_size);
                        index += data_size;
                        ptr += data_size;
                        // fetching description
                        data_size = *((size_t*)ptr);
                        current_profile.m_Description = (char*)malloc(data_size + 1);
                        if(current_profile.m_Description == NULL)
                        {
                            LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "malloc current_profile.m_Description");
                            return res;
                        }
                        index += sizeof(data_size);
                        ptr += sizeof(data_size);
                        memset(current_profile.m_Description, 0, data_size + 1);
                        memcpy(current_profile.m_Description, ptr, data_size);
                        index += data_size;
                        ptr += data_size;
                        // fetching is enabled
                        current_profile.m_IsEnabled = *((bool*)ptr);
                        index += sizeof(bool);
                        ptr += sizeof(bool);
                        // add to vector
                        m_profiles.push_back(current_profile);
                    }
                    if (!m_profiles.empty())
                    {
                        m_profiles_index = 1;
                        profile = m_profiles[0];
                        res = e_Ok;
                    }
                    else
                    {
                        res = e_NotFound;
                    }
                }
                else
                {
                    LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "read response payload from response fifo failed");
                }
            }
            else
            {
                LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "IPC daemon engine failed with request");
            }
        }
        else
        {
            LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "read response head from response fifo failed");
        }
    }
    else
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "write to request fifo failed");
    }

    return res;
}
//------------------------------------------------------------------------------------------------------
StatusCode ProfileManager::FetchNextProfileInfo(ProfileInfo& profile)
{
    StatusCode res = e_Failed;
    if (m_profiles_index >= m_profiles.size())
    {
        res = e_NotFound;
    }
    else
    {
        profile = m_profiles[m_profiles_index++];
        res = e_Ok;
    }
    return res;
}
//------------------------------------------------------------------------------------------------------
void ProfileManager::ReleaseProfileInfo(ProfileInfo& profile)
{
    if(profile.m_Name != NULL) free(profile.m_Name);
    if(profile.m_Description != NULL) free(profile.m_Description);
}
//------------------------------------------------------------------------------------------------------
StatusCode ProfileManager::EnableProfile(const String& Profile_name, bool enable)
{
    StatusCode res = e_Failed;

    if (Profile_name.empty())
    {
        return res;
    }

    UIExchangeHead request_head;
    memset(&request_head, 0, sizeof(UIExchangeHead));
    request_head.m_type = e_SetProfileState;
    request_head.m_payload_size = sizeof(size_t) + Profile_name.length() + sizeof(enable);
    Buffer buffer(sizeof(request_head) + sizeof(size_t) + Profile_name.length() + sizeof(enable), '\0');
    memcpy(buffer.GetPointer(), &request_head, sizeof(request_head));
    size_t name_length = Profile_name.length();
    memcpy((char*)buffer.GetPointer() + sizeof(request_head), &name_length, sizeof(name_length));
    memcpy((char*)buffer.GetPointer() + sizeof(request_head) + sizeof(name_length), Profile_name.c_str(), name_length);
    memcpy((char*)buffer.GetPointer() + sizeof(request_head) + sizeof(name_length) + name_length, &enable, sizeof(enable));

    if (m_fifo_request->Write(buffer) == e_Ok)
    {
        UIResponseExchangeHead response_head;
        buffer.Allocate(sizeof(response_head), '\0');
        if (m_fifo_response->Read(buffer, true) == e_Ok)
        {
            memset(&response_head, 0, sizeof(UIResponseExchangeHead));
            memcpy(&response_head, buffer.GetPointer(), buffer.Size());
            if (response_head.m_perform_code == e_Ok)
            {
                res = e_Ok;
            }
            else
            {
                LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "IPC daemon engine failed with request");
            }
        }
        else
        {
            LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "read response head from response fifo failed");
        }
    }
    else
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ProfileManagerLog), "write to request fifo failed");
    }

    return res;
}
//------------------------------------------------------------------------------------------------------

ProfileManager* GetProfileManager()
{
    return new(std::nothrow) ProfileManager;
}

}

