package com.funambol.omadmclient.android.service;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.widget.EditText;

public class UIAlertWindow extends Activity {
	private AlertDialog.Builder mAlertDialog = null;
	private EditText editText = null;
	private String mAlertType = "DefaultType";
	private String mAlertText = "DefaultText";
	private String[] mchoiceItems = null;
	private int mcheckedItem = 0;
	private boolean[] mcheckedFlags = null;
	private static final String CHOICE_SEPARATER = "-";
	private static final String LOGTAG = "UIAlertWindow";
	
    public void onCreate(Bundle savedInstanceState){
    	super.onCreate(savedInstanceState);
    	setContentView(R.layout.uialert);
    	
    	Bundle extras = getIntent().getExtras();
    	if(extras != null){
    		mAlertType = extras.getString(Constants.UIALERTTYPE);
    		mAlertText = extras.getString(Constants.UIALERTTEXT);
    		if( mAlertType.equals(Constants.UIALERT_TYPE_CHOICE) || mAlertType.equals(Constants.UIALERT_TYPE_MULTIPLECHOISE))
    		{
    			mchoiceItems = extras.getStringArray(Constants.AVAILABLE_CHOICE_ITEMS);
    		}
    	}
 
    	// Display
    	if(mAlertType.equals(Constants.UIALERT_TYPE_DISPLAY)){
    		Log.i(LOGTAG, "Enter Disaply");
        	mAlertDialog = new AlertDialog.Builder(UIAlertWindow.this);
    		mAlertDialog.setTitle(mAlertType);
    		mAlertDialog.setMessage(mAlertText);
    		mAlertDialog.setPositiveButton(R.string.okbutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_status = Constants.e_OK;
					Log.i(LOGTAG, "Exit Disaply");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});
    		mAlertDialog.show();
    	}
    	// Confirmation
    	else if(mAlertType.equals(Constants.UIALERT_TYPE_CONFIRMATION)){
    		Log.i(LOGTAG, "Enter Confirmation");
        	mAlertDialog = new AlertDialog.Builder(UIAlertWindow.this);
    		mAlertDialog.setTitle(mAlertType);
    		mAlertDialog.setMessage(mAlertText);
    		// Yes
    		mAlertDialog.setPositiveButton(R.string.positivebutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_status = Constants.e_OK;
					Log.i(LOGTAG, "Exit Confirmation: OK");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});
    		// No
    		mAlertDialog.setNegativeButton(R.string.negativebutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_status = Constants.e_NotExecuted;
					Log.i(LOGTAG, "Exit Confirmation: NO");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});
    		// Cancel
    		mAlertDialog.setNeutralButton(R.string.neutralbutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_status = Constants.e_NotExecuted;
					Log.i(LOGTAG, "Exit Confirmation: CANCELED");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});
    		mAlertDialog.show();
    	}
    	// Input
    	else if(mAlertType.equals(Constants.UIALERT_TYPE_INPUT)){
    		Log.i(LOGTAG, "Enter Input");
    		editText = new EditText(UIAlertWindow.this);
        	mAlertDialog = new AlertDialog.Builder(UIAlertWindow.this);
    		mAlertDialog.setTitle(mAlertType);
    		mAlertDialog.setMessage(mAlertText);
    		mAlertDialog.setView(editText);
    		// OK
    		mAlertDialog.setPositiveButton(R.string.okbutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_input = editText.getText().toString();
					NotificationCallbackInterface.m_status = Constants.e_OK;
					Log.i(LOGTAG, "Exit Input: OK");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});
    		// Cancel
    		mAlertDialog.setNeutralButton(R.string.neutralbutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_status = Constants.e_NotExecuted;
					Log.i(LOGTAG, "Exit Input: CALNCELED");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});
    		mAlertDialog.show();
    	}
    	// Choice
    	else if(mAlertType.equals(Constants.UIALERT_TYPE_CHOICE)){
    		Log.i(LOGTAG, "Enter Choice");
    		for(int i=0;i<mchoiceItems.length;i++)
    		{
    			Log.i(LOGTAG, mchoiceItems[i]);
    		}
      		mAlertDialog = new AlertDialog.Builder(UIAlertWindow.this);
    		mAlertDialog.setTitle(mAlertText);
    		mAlertDialog.setSingleChoiceItems(mchoiceItems, mcheckedItem, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					mcheckedItem = which;
				}
			});
    		// OK
    		mAlertDialog.setPositiveButton(R.string.okbutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_status = Constants.e_OK;
//					NotificationCallbackInterface.m_choice_set = mchoiceItems[mcheckedItem];
					NotificationCallbackInterface.m_choice_set = Integer.toString(mcheckedItem + 1);
					Log.i(LOGTAG, "Exit Choice: OK");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});
    		// Cancel
    		mAlertDialog.setNeutralButton(R.string.neutralbutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_status = Constants.e_NotExecuted;
					Log.i(LOGTAG, "Exit Choice: CANCELED");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});
    		mAlertDialog.show();
    	}
    	// Multiple Choice
    	else if(mAlertType.equals(Constants.UIALERT_TYPE_MULTIPLECHOISE)){
    		Log.i(LOGTAG, "Enter Multiple Choice");
    		int length = mchoiceItems.length;
    		mcheckedFlags = new boolean[length];
    		mcheckedFlags[0] = true;
    		if(length > 0)
    		{
    			for(int i = 1; i < length; i++)
    			{
    				mcheckedFlags[i] = false;
    			}
    		}
    		mAlertDialog = new AlertDialog.Builder(UIAlertWindow.this);
    		mAlertDialog.setTitle(mAlertText);
    		mAlertDialog.setMultiChoiceItems(mchoiceItems, mcheckedFlags, new DialogInterface.OnMultiChoiceClickListener() {	
				public void onClick(DialogInterface dialog, int which, boolean isChecked) {
					mcheckedFlags[which] = isChecked;
				}
			});
    		// OK
    		mAlertDialog.setPositiveButton(R.string.okbutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_status = Constants.e_OK;
					int length = mcheckedFlags.length;
					boolean existed = false;
					StringBuilder sb = new StringBuilder("");
					for(int i = 0; i < length; i++)
					{
						if(mcheckedFlags[i])
						{
							if(existed)
							{
								sb.append(CHOICE_SEPARATER).append(i+1);
							}
							else
							{
								sb.append(i+1);
								existed = true;
							}
						}
					}
					NotificationCallbackInterface.m_choice_set = sb.toString();
					Log.i(LOGTAG, "Exit Multiple Choice: OK");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});
    		// Cancel
    		mAlertDialog.setNeutralButton(R.string.neutralbutton_label, new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int which) {
					NotificationCallbackInterface.m_status = Constants.e_NotExecuted;
					Log.i(LOGTAG, "Exit Multiple Choice: CANCELED");
					synchronized(NotificationCallbackInterface.m_callBack){
						NotificationCallbackInterface.m_callBack.notifyAll();
					}
					finish();
				}
			});	
    		mAlertDialog.show();
    	}
    	// Unknown
    	else {
    		finish();
    	}
    }
    
    protected void onStart(){
    	super.onStart();
    	Log.i(LOGTAG, "onStart");
    	NotificationCallbackInterface.m_result = true;
    }
    
    protected void onStop(){
    	super.onStop();
    	Log.i(LOGTAG, "onStop");
    }
}
