/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "DeviceAdapter/Diagnostics/SDKMocks/SDKMocks.h"
#include "Utils.h"

#include <stdio.h>
#include <string.h>

UINT8 SetDiagnosticsStart(ST_Diag_Start_P* start) // ST_Diag_Start** start
{
    *start = new ST_Diag_Start;

    // set default mock values
    (*start)->Duration = 64;
    __strcpy((char*)((*start)->Server_ID), "Mock server"); // MAX_START_SERVER_ID 20
    __strcpy((char*)((*start)->Origination_ID), "Mock origination"); // MAX_START_ORIGINATION_ID 255

    return 1;
}

//-------------------------------------------------------------------------------------------

UINT8 ReleaseDiagnosticsStart(ST_Diag_Start_P start) // ST_Diag_Start* start
{
    delete start;
    return 1;
}

//-------------------------------------------------------------------------------------------

UINT8 SetDiagnosticsWiMAX(ST_Diag_WiMAX_P* wimax) // ST_Diag_WiMAX** start
{
    *wimax = new ST_Diag_WiMAX;

	// set default values
	(*wimax)->ServBSID = 64;
    (*wimax)->DownlinkFreq = 64;
	(*wimax)->DownlinkBandwidth = 64;
	__strcpy((char*)((*wimax)->DownlinkMeanRSSI), "Mock DownlinkMeanRSSI"); // MAX_WIMAX_DOWNLINK_MEAN_RSSI 62
	__strcpy((char*)((*wimax)->DownlinkStdDevRSSI), "Mock DownlinkStdDevRSSI"); // MAX_WIMAX_DOWNLINK_STD_DEV_RSSI 71
	__strcpy((char*)((*wimax)->DownlinkMeanCINR), "Mock DownlinkMeanCINR"); // MAX_WIMAX_DOWNLINK_MEAN_CINR 62
	__strcpy((char*)((*wimax)->DownlinkStdDevCINR), "Mock DownlinkStdDevCINR"); // MAX_WIMAX_DOWNLINK_STD_DEV_CINR 62
    (*wimax)->TxPwr = 64;
	(*wimax)->TxHeadroomPwr = 64;
	__strcpy((char*)((*wimax)->ScannedBaseStations), "Mock ScannedBaseStations"); // MAX_WIMAX_SCANNED_BASE_STATIONS 233
	(*wimax)->LinkUptime = 64;
	__strcpy((char*)((*wimax)->HARQRetTX), "Mock HARQRetTX"); // MAX_WIMAX_HARQ_RET_TX 53
	__strcpy((char*)((*wimax)->HARQRetRX), "Mock HARQRetRX"); // MAX_WIMAX_HARQ_RET_RX 53
    (*wimax)->InitRangeResp = 64;
	(*wimax)->InitRangeNoResp = 64;
	(*wimax)->PerRangeResp = 64;
    (*wimax)->PerRangeNoResp = 64;
	(*wimax)->HOSuccess = 64;
    (*wimax)->HOFail = 64;
	(*wimax)->MAPRecSuccess = 64;
	(*wimax)->MAPRecFail = 64;
	__strcpy((char*)((*wimax)->MCSstatsDL), "Mock MCSstatsDL"); // MAX_WIMAX_MCS_STATS_DL 6719
	__strcpy((char*)((*wimax)->MCSstatsUL), "Mock MCSstatsUL"); // MAX_WIMAX_MCS_STATS_UL 5039
	(*wimax)->VersionOfMCSMetric = 64;
	__strcpy((char*)((*wimax)->DownlinkDataRate), "Mock DownlinkDataRate"); // MAX_WIMAX_DOWNLINK_DATA_RATE 62
	__strcpy((char*)((*wimax)->UplinkDataRate), "Mock UplinkDataRate"); // MAX_WIMAX_UPLINK_DATA_RATE 62
	(*wimax)->PacketsReceived = 64;
	(*wimax)->PacketsSent = 64;
	__strcpy((char*)((*wimax)->MACState), "Mock MAC"); // MAX_WIMAX_MAC_STATE 10. Only 9 symbols allowed. Truncate input
	__strcpy((char*)((*wimax)->PreambleIndex), "Mock Preamble"); // MAX_WIMAX_PREAMBLE_INDEX 16. Only 15 symbols allowed. Truncate input
	(*wimax)->HOLatency = 64;
	__strcpy((char*)((*wimax)->FrameRatio), "Mock Frame"); // MAX_WIMAX_FRAME_RATIO 16. Only 15 symbols allowed. Truncate input
	(*wimax)->HOAttempts = 64;
	(*wimax)->NetworkEntryLatency = 64;
	(*wimax)->NetworkEntrySucceses = 64;
	(*wimax)->NetworkEntryFailures = 64;
	(*wimax)->NetworkEntryAttempts = 64;
	(*wimax)->UserAccessTime = 64;

    return 1;
}

//-------------------------------------------------------------------------------------------

UINT8 ReleaseDiagnosticsWiMAX(ST_Diag_WiMAX_P wimax) // ST_Diag_WiMAX* wimax
{
    delete wimax;
    return 1;
}

//-------------------------------------------------------------------------------------------

UINT8 SetDiagnosticsGeneric(ST_Diag_Generic_P* generic) // ST_Diag_Generic** generic
{
    *generic = new ST_Diag_Generic;

	(*generic)->RateLimiterStats = 64;
    (*generic)->TimeActive = 64;
	(*generic)->TimeIdle = 64;
	(*generic)->TimeSleep = 64;
	__strcpy((char*)((*generic)->LastRebootCause), "Mock LastRebootCause"); // MAX_GENERIC_LAST_REBOOT_CAUSE 32
	(*generic)->DeviceTemp = 64;
	(*generic)->SupVolt = 64;
	(*generic)->BatteryCap = 64;
	(*generic)->GPSlocation_Latitude  = 64;
	(*generic)->GPSlocation_Longitude = 64;
	(*generic)->GPSlocation_Altitude = 64;

    // ST_Diag_LANEtherMAC
    for (size_t i = 0; i < MAX_SIZE_LAN_ETHER_MAC_ARRAY; ++i)
    {
        __strcpy((char*)((*generic)->lanEtherMAC[i].Enable), "Y"); // MAX_LANETHERMAC_ENABLE 2. Truncate input
        __strcpy((char*)((*generic)->lanEtherMAC[i].MACAddressControlEnabled), "Y"); // MAX_LANETHERMAC_MAC_ADDRESS_CONTROL_ENABLED 2. Truncate input
        __strcpy((char*)((*generic)->lanEtherMAC[i].MaxBitrate), "MaxBrate"); // MAX_LANETHERMAC_MAX_BIT_RATE 10. Truncate input
        __strcpy((char*)((*generic)->lanEtherMAC[i].DuplexMode), "Y"); // MAX_LANETHERMAC_DUPLEX_MODE 2. Truncate input
        __strcpy((char*)((*generic)->lanEtherMAC[i].LANEtherMACresults), "MACres"); // MAX_LANETHERMAC_LAN_ETHER_MAC_RESULTS 10. Truncate input
    }

    // ST_Diag_IPPingDiagnostics

    for (size_t i = 0; i < MAX_SIZE_DIAG_IP_PING_DIAGNOSTICS_ARRAY; ++i)
    {
        	__strcpy((char*)((*generic)->iPPingDiagnostics[i].DiagnosticsState), "State success"); // MAX_IPPINGDIAGNOSTICS_DIAGNOSTICS_STATE 15. Truncate input
        	__strcpy((char*)((*generic)->iPPingDiagnostics[i].Interface), "Interface"); // MAX_IPPINGDIAGNOSTICS_INTERFACE 15. Truncate input
        	__strcpy((char*)((*generic)->iPPingDiagnostics[i].Host), "Host"); // MAX_IPPINGDIAGNOSTICS_HOST 15. Truncate input
	        (*generic)->iPPingDiagnostics[i].NumberOfRepetition = 64;
	        (*generic)->iPPingDiagnostics[i].Timeout = 64;
	        (*generic)->iPPingDiagnostics[i].DataBlockSize = 64;
	        (*generic)->iPPingDiagnostics[i].DSCP = 64;
        	__strcpy((char*)((*generic)->iPPingDiagnostics[i].IPPingDiagnosticsResults), "Results"); // MAX_IPPINGDIAGNOSTICS_IP_PING_DIAGNOSTICS_RESULTS 15. Truncate input
    }

    (*generic)->DeviceUptime = 64;
	__strcpy((char*)((*generic)->DeviceLog), "DeviceLog"); // MAX_GENERIC_DEVICE_LOG 10. Truncate input
	__strcpy((char*)((*generic)->Primary_DNS), "Mock Primary_DNS"); // MAX_GENERIC_PRIMARY_DNS 128
	__strcpy((char*)((*generic)->Secondary_DNS), "Mock Secondary_DNS"); // MAX_GENERIC_SECONDARY_DNS 128
	__strcpy((char*)((*generic)->Gateway), "Mock Gateway"); // MAX_GENERIC_GATEWAY 128
	__strcpy((char*)((*generic)->Subnet_Mask), "Mock Subnet_Mask"); // MAX_GENERIC_SUBNET_MASK 128
	__strcpy((char*)((*generic)->Wimax_Interface_IP_Addr), "Mock Wimax_Interface_IP_Addr"); // MAX_GENERIC_WIMAX_INTERFACE_IP_ADDR 128
    (*generic)->DHCP_Leases = 64;
	__strcpy((char*)((*generic)->Port_Forwarding), "Mock Port_Forwarding"); // MAX_GENERIC_PORT_FORWARDING 128

    return 1;
}

UINT8 ReleaseDiagnosticsGeneric(ST_Diag_Generic_P generic) // ST_Diag_Generic* generic
{
    delete generic;

    return 1;
}

UINT8 SetDiagnosticsExt(ST_Diag_Ext_P* ext)
{
    *ext = new ST_Diag_Ext;

    // set default mock values
    (*ext)->Platform_Memory = 64;
    (*ext)->Processor_id = 64;
    __strcpy((char*)((*ext)->Processor_type), "Mock processor"); // MAX_EXT_PROCESSOR_TYPE 20
    (*ext)->CPU_Utilization = 64;
    (*ext)->RAM_Utilization = 64;
    __strcpy((char*)((*ext)->Hard_Drive_Number), "Mock HDD"); // MAX_EXT_HARD_DRIVE_NUMBER 20

    return 1;
}

UINT8 ReleaseDiagnosticsExt(ST_Diag_Ext_P ext)
{
    delete ext;

    return 1;
}
