/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "ManagementObjects/WiMAX_Diagnostics.h"

//#ifdef DRMD_SDK_MOCK
    #include "DeviceAdapter/Diagnostics/SDKMocks/SDKMocks.h"
//#else
//    NULL; // include real path TO DRMD SDK
//#endif

namespace NS_DM_Client
{
namespace NS_DM_Diagnostics
{
    bool TranslateStart(ST_Diag_Start_P in, Start& out);
    bool TranslateWiMAX(ST_Diag_WiMAX_P in, WiMAX& out);
    bool TranslateGeneric(ST_Diag_Generic_P in, Generic& out);
    bool TranslateLANEtherMAC(ST_Diag_LANEtherMAC_P in, LANEtherMAC& out);
    bool TranslateIPPingDiagnostics(ST_Diag_IPPingDiagnostics_P in, IPPingDiagnostics& out);
    bool TranslateExt(ST_Diag_Ext_P in, Ext& out);
}
}
