#include "Common.h"
#include "treemanager/IMOTreeManager.h"
#include <syncml/core/Item.h>
#include <Logger/LoggerMacroses.h>

const char* const c_LogName = "MOCommon";

namespace NS_DM_Client
{
    bool Serialize(const String& path, const String& data, IMOTreeManager& treeManager, const String& format)
    {
        Funambol::Item item;
        Funambol::Target target(path.c_str());
        item.setTarget(&target);
        Funambol::Meta meta;
        meta.setType("text/plain");
        meta.setFormat(format.c_str());
        item.setMeta(&meta);
        Funambol::ComplexData complexData(data.c_str());
        item.setData(&complexData);

        StatusCode status = treeManager.Add(path, item, 0, false);
        if (e_AlreadyExists == status)
        {
            status = treeManager.Replace(path, item, 0, false);
        }
        return status == e_Ok? true: false;
    }
    //-------------------------------------------------------------------------------------------

    bool Deserialize(const String& path, String& data, IMOTreeManager& treeManager)
    {
        return (e_Ok == treeManager.GetValue(path, data));
    }
    //-------------------------------------------------------------------------------------------

    bool Deserialize(const String& path, size_t& data, IMOTreeManager& treeManager)
    {
        String value;
        bool res = (e_Ok == treeManager.GetValue(path, value));
        if (res)
        {
            data = atoi(value.c_str());
        }
        return res;
    }
    //-------------------------------------------------------------------------------------------

    bool Deserialize(const String& path, int& data, IMOTreeManager& treeManager)
    {
        String value;
        bool res = (e_Ok == treeManager.GetValue(path, value));
        if (res)
        {
            data = atoi(value.c_str());
        }
        return res;
    }

    //-------------------------------------------------------------------------------------------

    bool Deserialize(const String& path, bool& data, IMOTreeManager& treeManager)
    {
        String value;
        bool res = (e_Ok == treeManager.GetValue(path, value));
        if (res)
        {
            data = (value == S_true);
        }
        return res;
    }
    //-------------------------------------------------------------------------------------------

    bool Deserialize(const String& path, UINT8& data, IMOTreeManager& treeManager)
    {
        String value;
        bool res = (e_Ok == treeManager.GetValue(path, value));
        if (res)
        {
            data = atoi(value.c_str());
        }
        return res;
    }
    //-------------------------------------------------------------------------------------------

    void ToString(String& destination, void* source, int size)
    {
        char* tmpContent = new char[size + 1];
        if(tmpContent == NULL)
        {
            GDLERROR("new tmpContent");
            return;
        }
        memset(tmpContent, 0, size + 1); // last 0 added
        memcpy(tmpContent, source, size);
        destination = tmpContent;
        delete [] tmpContent;
    }
    //-------------------------------------------------------------------------------------------

    String BoolToString(bool source)
    {
        String res = source? S_true: S_false;
        return res;
    }
}
