/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#include "WiMAX_Diagnostics.h"
#include "Common.h"
#include "TNDSMgmtTree/TNDSCreator.h"
#include "TNDSMgmtTree/TNDSExtractor.h"
#include "treemanager/IMOTreeManager.h"

//#ifdef DRMD_SDK_MOCK
    #include "DeviceAdapter/Diagnostics/SDKMocks/SDKMocks.h"
//#else
//    NULL; // include real path TO DRMD SDK
//#endif

#include "../Diagnostics/TranslateDiagnosticsStructures.h"

const char* const c_DiagnosticsLog = "Diagnostics";

namespace NS_DM_Client
{
namespace NS_DM_Diagnostics
{

    enum WiMAX_DiagnisticsEnum
    {
        e_Start = 0,
        e_WiMAX,
        e_Generic,
        e_Ext
    };

    const String WiMAX_DiagnisticsFieldPath[] =
    {
        "./WiMAX_Diagnostics",
        "./WiMAX_Diagnostics",
        "./WiMAX_Diagnostics",
        "./WiMAX_Diagnostics"
    };

    const String WiMAX_DiagnisticsFieldName[] =
    {
        "Start",
        "WiMAX",
        "Generic",
        "Ext"
    };

    //-------------------------------------------------------------------------------------------

    enum StartEnum
    {
        e_Duration = 0,
        e_Server_ID,
        e_Origination_ID
    };

    const char* StartFieldName[] =
    {
        "Duration",
        "Server_ID",
        "Origination_ID"
    };

    //-------------------------------------------------------------------------------------------

    enum WiMAXEnum
    {
        e_ServBSID = 0,
        e_DownlinkFreq,
        e_DownlinkBandwidth,
        e_DownlinkMeanRSSI,
        e_DownlinkStdDevRSSI,
        e_DownlinkMeanCINR,
        e_DownlinkStdDevCINR,
        e_TxPwr,
        e_TxHeadroomPwr,
        e_ScannedBaseStations,
        e_LinkUptime,
        e_HARQRetTX,
        e_HARQRetRX,
        e_InitRangeResp,
        e_InitRangeNoResp,
        e_PerRangeResp,
        e_PerRangeNoResp,
        e_HOSuccess,
        e_HOFail,
        e_MAPRecSuccess,
        e_MAPRecFail,
        e_MCSstatsDL,
        e_MCSstatsUL,
        e_VersionOfMCSMetric,
        e_DownlinkDataRate,
        e_UplinkDataRate,
        e_PacketsReceived,
        e_PacketsSent,
        // DMRD SDK specific fields
        e_MACState,
        e_PreambleIndex,
        e_HOLatency,
        e_FrameRatio,
        e_HOAttempts,
        e_NetworkEntryLatency,
        e_NetworkEntrySucceses,
        e_NetworkEntryFailures,
        e_NetworkEntryAttempts,
        e_UserAccessTime,
        // BA PARAMS NOT IN DRMD ? CR PENDING
        e_ARQ_Retries_Received,
        e_ARQ_Retries_Transmitted,
        e_CQICH,
        e_Service_Flows,
        e_Airlink_Security,
        e_Certificates
    };

    const char* WiMAXFieldName[] =
    {
        "ServBSID",
        "DownlinkFreq",
        "DownlinkBandwidth",
        "DownlinkMeanRSSI",
        "DownlinkStdDevRSSI",
        "DownlinkMeanCINR",
        "DownlinkStdDevCINR",
        "TxPwr",
        "TxHeadroomPwr",
        "ScannedBaseStations",
        "LinkUptime",
        "HARQRetTX",
        "HARQRetRX",
        "InitRangeResp",
        "InitRangeNoResp",
        "PerRangeResp",
        "PerRangeNoResp",
        "HOSuccess",
        "HOFail",
        "MAPRecSuccess",
        "MAPRecFail",
        "MCSstatsDL",
        "MCSstatsUL",
        "VersionOfMCSMetric",
        "DownlinkDataRate",
        "UplinkDataRate",
        "PacketsReceived",
        "PacketsSent",
        // DMRD SDK specific fields
        "MACState",
        "PreambleIndex",
        "HOLatency",
        "FrameRatio",
        "HOAttempts",
        "NetworkEntryLatency",
        "NetworkEntrySucceses",
        "NetworkEntryFailures",
        "NetworkEntryAttempts",
        "UserAccessTime",
        // BA PARAMS NOT IN DRMD ? CR PENDING
        "ARQ_Retries_Received",
        "ARQ_Retries_Transmitted",
        "CQICH",
        "Service_Flows",
        "Airlink_Security",
        "Certificates"
    };

    //-------------------------------------------------------------------------------------------

    enum GenericEnum
    {
        e_RateLimiterStats = 0,
        e_TimeActive,
        e_TimeIdle,
        e_TimeSleep,
        e_LastRebootCause,
        e_DeviceTemp,
        e_SupVolt,
        e_BatteryCap,
        e_GPSlocation_Latitude,
        e_GPSlocation_Longitude,
        e_GPSlocation_Altitude,
        e_LANEtherMAC_Enable,
        e_LANEtherMAC_MACAddressControlEnabled,
        e_LANEtherMAC_MaxBitrate,
        e_LANEtherMAC_DuplexMode,
        e_LANEtherMAC_LANEtherMACresults,
        e_IPPingDiagnostics_DiagnosticsState,
        e_IPPingDiagnostics_Interface,
        e_IPPingDiagnostics_Host,
        e_IPPingDiagnostics_NumberOfRepetition,
        e_IPPingDiagnostics_Timeout,
        e_IPPingDiagnostics_DataBlockSize,
        e_IPPingDiagnostics_DSCP,
        e_IPPingDiagnostics_IPPingDiagnosticsResults,
        // NOT IN DRMD SPEC BUT WILL BE SUBMITTED AS CR
        e_DeviceUptime,
        e_DeviceLog,
        e_Primary_DNS,
        e_Secondary_DNS,
        e_Gateway,
        e_Subnet_Mask,
        e_Wimax_Interface_IP_Addr,
        e_DHCP_Leases,
        e_Port_Forwarding
    };

    const char* GenericFieldName[] =
    {
        "RateLimiterStats",
        "TimeActive",
        "TimeIdle",
        "TimeSleep",
        "LastRebootCause",
        "DeviceTemp",
        "SupVolt",
        "BatteryCap",
        "GPSlocation_Latitude",
        "GPSlocation_Longitude",
        "GPSlocation_Altitude",
        "LANEtherMAC/Enable",
        "LANEtherMAC/MACAddressControlEnabled",
        "LANEtherMAC/MaxBitrate",
        "LANEtherMAC/DuplexMode",
        "LANEtherMAC/LANEtherMACresults",
        "IPPingDiagnostics/DiagnosticsState",
        "IPPingDiagnostics/Interface",
        "IPPingDiagnostics/Host",
        "IPPingDiagnostics/NumberOfRepetition",
        "IPPingDiagnostics/Timeout",
        "IPPingDiagnostics/DataBlockSize",
        "IPPingDiagnostics/DSCP",
        "IPPingDiagnostics/IPPingDiagnosticsResults",
        // NOT IN DRMD SPEC BUT WILL BE SUBMITTED AS CR
        "DeviceUptime",
        "DeviceLog",
        "Primary_DNS",
        "Secondary_DNS",
        "Gateway",
        "Subnet_Mask",
        "Wimax_Interface_IP_Addr",
        "DHCP_Leases",
        "Port_Forwarding"
    };

    enum ExtEnum
    {
        e_Platform_Memory = 0,
        e_Processor_id,
        e_Processor_type,
        e_CPU_Utilization,
        e_RAM_Utilization,
        e_Hard_Drive_Number
    };

    const char* ExtFieldName[] =
    {
        "Platform_Memory",
        "Processor_id",
        "Processor_type",
        "CPU_Utilization",
        "RAM_Utilization",
        "Hard_Drive_Number"
    };

    //-------------------------------------------------------------------------------------------

    bool Start::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Start::Serialize");

        bool res = NS_DM_Client::Serialize(basePathName + S_slash + StartFieldName[e_Duration], ToString(m_Duration), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + StartFieldName[e_Server_ID], m_Server_ID, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + StartFieldName[e_Origination_ID], m_Origination_ID, treeManager);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Start::Serialize. Res: %d", res);
        return res;
    }
    //-------------------------------------------------------------------------------------------

    bool Start::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Start::Deserialize");

        bool res = NS_DM_Client::Deserialize(basePathName + S_slash + StartFieldName[e_Duration], m_Duration, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + StartFieldName[e_Server_ID], m_Server_ID, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + StartFieldName[e_Origination_ID], m_Origination_ID, treeManager);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Start::Deserialize. Res: %d", res);
        return res;
    }
    //-------------------------------------------------------------------------------------------

    bool Start::Serialize(const String& basePathName, TNDSCreator& tree) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Start::Serialize");

        tree.Append(basePathName, StartFieldName[e_Duration], ToString(m_Duration));
        tree.Append(basePathName, StartFieldName[e_Server_ID], m_Server_ID);
        tree.Append(basePathName, StartFieldName[e_Origination_ID], m_Origination_ID);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Start::Serialize. Res: 1");
        return true;
    }
    //-------------------------------------------------------------------------------------------

    bool Start::Deserialize(const String& basePathName, TNDSExtractor& tree)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Start::Deserialize");

        tree.GetValue(basePathName, StartFieldName[e_Duration], m_Duration);
        tree.GetValue(basePathName, StartFieldName[e_Server_ID], m_Server_ID);
        tree.GetValue(basePathName, StartFieldName[e_Origination_ID], m_Origination_ID);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Start::Deserialize. Res: 1");
        return true;
    }

    //-------------------------------------------------------------------------------------------
    //-------------------------------------------------------------------------------------------
    //-------------------------------------------------------------------------------------------

    bool WiMAX::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> WiMAX::Serialize");

        bool res = NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_ServBSID], ToString(m_ServBSID), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkFreq], ToString(m_DownlinkFreq), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkBandwidth], ToString(m_DownlinkBandwidth), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkMeanRSSI], m_DownlinkMeanRSSI, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkStdDevRSSI], m_DownlinkStdDevRSSI, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkMeanCINR], m_DownlinkMeanCINR, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkStdDevCINR], m_DownlinkStdDevCINR, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_TxPwr], ToString(m_TxPwr), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_TxHeadroomPwr], ToString(m_TxHeadroomPwr), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_ScannedBaseStations], m_ScannedBaseStations, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_LinkUptime], ToString(m_LinkUptime), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_HARQRetTX], m_HARQRetTX, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_HARQRetRX], m_HARQRetRX, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_InitRangeResp], ToString(m_InitRangeResp), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_InitRangeNoResp], ToString(m_InitRangeNoResp), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_PerRangeResp], ToString(m_PerRangeResp), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_PerRangeNoResp], ToString(m_PerRangeNoResp), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_HOSuccess], ToString(m_HOSuccess), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_HOFail], ToString(m_HOFail), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_MAPRecSuccess], ToString(m_MAPRecSuccess), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_MAPRecFail], ToString(m_MAPRecFail), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_MCSstatsDL], m_MCSstatsDL, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_MCSstatsUL], m_MCSstatsUL, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_VersionOfMCSMetric], ToString(m_VersionOfMCSMetric), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkDataRate], m_DownlinkDataRate, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_UplinkDataRate], m_UplinkDataRate, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_PacketsReceived], ToString(m_PacketsReceived), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_PacketsSent], ToString(m_PacketsSent), treeManager, S_intFormat);
        // DMRD SDK specific fields
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_MACState], m_MACState, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_PreambleIndex], m_PreambleIndex, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_HOLatency], ToString(m_HOLatency), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_FrameRatio], m_FrameRatio, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_HOAttempts], ToString(m_HOAttempts), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_NetworkEntryLatency], ToString(m_NetworkEntryLatency), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_NetworkEntrySucceses], ToString(m_NetworkEntrySucceses), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_NetworkEntryFailures], ToString(m_NetworkEntryFailures), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_NetworkEntryAttempts], ToString(m_NetworkEntryAttempts), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_UserAccessTime], ToString(m_UserAccessTime), treeManager, S_intFormat);
        // BA PARAMS NOT IN DRMD ? CR PENDING
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_ARQ_Retries_Received], ToString(m_ARQ_Retries_Received), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_ARQ_Retries_Transmitted], ToString(m_ARQ_Retries_Transmitted), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_CQICH], ToString(m_CQICH), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_Service_Flows], m_Service_Flows, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_Airlink_Security], m_Airlink_Security, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + WiMAXFieldName[e_Certificates], m_Certificates, treeManager);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << WiMAX::Serialize. Res: %d", res);
        return res;
    }
    //-------------------------------------------------------------------------------------------

    bool WiMAX::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> WiMAX::Deserialize");

        bool res = NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_ServBSID], m_ServBSID, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkFreq], m_DownlinkFreq, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkBandwidth], m_DownlinkBandwidth, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkMeanRSSI], m_DownlinkMeanRSSI, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkStdDevRSSI], m_DownlinkStdDevRSSI, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkMeanCINR], m_DownlinkMeanCINR, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkStdDevCINR], m_DownlinkStdDevCINR, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_TxPwr], m_TxPwr, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_TxHeadroomPwr], m_TxHeadroomPwr, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_ScannedBaseStations], m_ScannedBaseStations, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_LinkUptime], m_LinkUptime, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_HARQRetTX], m_HARQRetTX, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_HARQRetRX], m_HARQRetRX, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_InitRangeResp], m_InitRangeResp, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_InitRangeNoResp], m_InitRangeNoResp, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_PerRangeResp], m_PerRangeResp, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_PerRangeNoResp], m_PerRangeNoResp, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_HOSuccess], m_HOSuccess, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_HOFail], m_HOFail, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_MAPRecSuccess], m_MAPRecSuccess, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_MAPRecFail], m_MAPRecFail, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_MCSstatsDL], m_MCSstatsDL, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_MCSstatsUL], m_MCSstatsUL, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_VersionOfMCSMetric], m_VersionOfMCSMetric, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_DownlinkDataRate], m_DownlinkDataRate, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_UplinkDataRate], m_UplinkDataRate, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_PacketsReceived], m_PacketsReceived, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_PacketsSent], m_PacketsSent, treeManager);
        // DMRD SDK specific fields     
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_MACState], m_MACState, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_PreambleIndex], m_PreambleIndex, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_HOLatency], m_HOLatency, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_FrameRatio], m_FrameRatio, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_HOAttempts], m_HOAttempts, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_NetworkEntryLatency], m_NetworkEntryLatency, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_NetworkEntrySucceses], m_NetworkEntrySucceses, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_NetworkEntryFailures], m_NetworkEntryFailures, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_NetworkEntryAttempts], m_NetworkEntryAttempts, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_UserAccessTime], m_UserAccessTime, treeManager);
        // BA PARAMS NOT IN DRMD ? CR PENDING
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_ARQ_Retries_Received], m_ARQ_Retries_Received, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_ARQ_Retries_Transmitted], m_ARQ_Retries_Transmitted, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_CQICH], m_CQICH, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_Service_Flows], m_Service_Flows, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_Airlink_Security], m_Airlink_Security, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + WiMAXFieldName[e_Certificates], m_Certificates, treeManager);
        
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << WiMAX::Deserialize. Res: %d", res);
        return res;
    }
    //-------------------------------------------------------------------------------------------

    bool WiMAX::Serialize(const String& basePathName, TNDSCreator& tree) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> WiMAX::Serialize");

        tree.Append(basePathName, WiMAXFieldName[e_ServBSID], ToString(m_ServBSID));
        tree.Append(basePathName, WiMAXFieldName[e_DownlinkFreq], ToString(m_DownlinkFreq));
        tree.Append(basePathName, WiMAXFieldName[e_DownlinkBandwidth], ToString(m_DownlinkBandwidth));
        tree.Append(basePathName, WiMAXFieldName[e_DownlinkMeanRSSI], m_DownlinkMeanRSSI);
        tree.Append(basePathName, WiMAXFieldName[e_DownlinkStdDevRSSI], m_DownlinkStdDevRSSI);
        tree.Append(basePathName, WiMAXFieldName[e_DownlinkMeanCINR], m_DownlinkMeanCINR);
        tree.Append(basePathName, WiMAXFieldName[e_DownlinkStdDevCINR], m_DownlinkStdDevCINR);
        tree.Append(basePathName, WiMAXFieldName[e_TxPwr], ToString(m_TxPwr));
        tree.Append(basePathName, WiMAXFieldName[e_TxHeadroomPwr], ToString(m_TxHeadroomPwr));
        tree.Append(basePathName, WiMAXFieldName[e_ScannedBaseStations], m_ScannedBaseStations);
        tree.Append(basePathName, WiMAXFieldName[e_LinkUptime], ToString(m_LinkUptime));
        tree.Append(basePathName, WiMAXFieldName[e_HARQRetTX], m_HARQRetTX);
        tree.Append(basePathName, WiMAXFieldName[e_HARQRetRX], m_HARQRetRX);
        tree.Append(basePathName, WiMAXFieldName[e_InitRangeResp], ToString(m_InitRangeResp));
        tree.Append(basePathName, WiMAXFieldName[e_InitRangeNoResp], ToString(m_InitRangeNoResp));
        tree.Append(basePathName, WiMAXFieldName[e_PerRangeResp], ToString(m_PerRangeResp));
        tree.Append(basePathName, WiMAXFieldName[e_PerRangeNoResp], ToString(m_PerRangeNoResp));
        tree.Append(basePathName, WiMAXFieldName[e_HOSuccess], ToString(m_HOSuccess));
        tree.Append(basePathName, WiMAXFieldName[e_HOFail], ToString(m_HOFail));
        tree.Append(basePathName, WiMAXFieldName[e_MAPRecSuccess], ToString(m_MAPRecSuccess));
        tree.Append(basePathName, WiMAXFieldName[e_MAPRecFail], ToString(m_MAPRecFail));
        tree.Append(basePathName, WiMAXFieldName[e_MCSstatsDL], m_MCSstatsDL);
        tree.Append(basePathName, WiMAXFieldName[e_MCSstatsUL], m_MCSstatsUL);
        tree.Append(basePathName, WiMAXFieldName[e_VersionOfMCSMetric], ToString(m_VersionOfMCSMetric));
        tree.Append(basePathName, WiMAXFieldName[e_DownlinkDataRate], m_DownlinkDataRate);
        tree.Append(basePathName, WiMAXFieldName[e_UplinkDataRate], m_UplinkDataRate);
        tree.Append(basePathName, WiMAXFieldName[e_PacketsReceived], ToString(m_PacketsReceived));
        tree.Append(basePathName, WiMAXFieldName[e_PacketsSent], ToString(m_PacketsSent));
        // DMRD SDK specific fields
        tree.Append(basePathName, WiMAXFieldName[e_MACState], m_MACState);
        tree.Append(basePathName, WiMAXFieldName[e_PreambleIndex], m_PreambleIndex);
        tree.Append(basePathName, WiMAXFieldName[e_HOLatency], ToString(m_HOLatency));
        tree.Append(basePathName, WiMAXFieldName[e_FrameRatio], m_FrameRatio);
        tree.Append(basePathName, WiMAXFieldName[e_HOAttempts], ToString(m_HOAttempts));
        tree.Append(basePathName, WiMAXFieldName[e_NetworkEntryLatency], ToString(m_NetworkEntryLatency));
        tree.Append(basePathName, WiMAXFieldName[e_NetworkEntrySucceses], ToString(m_NetworkEntrySucceses));
        tree.Append(basePathName, WiMAXFieldName[e_NetworkEntryFailures], ToString(m_NetworkEntryFailures));
        tree.Append(basePathName, WiMAXFieldName[e_NetworkEntryAttempts], ToString(m_NetworkEntryAttempts));
        tree.Append(basePathName, WiMAXFieldName[e_UserAccessTime], ToString(m_UserAccessTime));
        // BA PARAMS NOT IN DRMD ? CR PENDING
        tree.Append(basePathName, WiMAXFieldName[e_ARQ_Retries_Received], ToString(m_ARQ_Retries_Received));
        tree.Append(basePathName, WiMAXFieldName[e_ARQ_Retries_Transmitted], ToString(m_ARQ_Retries_Transmitted));
        tree.Append(basePathName, WiMAXFieldName[e_CQICH], ToString(m_CQICH));
        tree.Append(basePathName, WiMAXFieldName[e_Service_Flows], m_Service_Flows);
        tree.Append(basePathName, WiMAXFieldName[e_Airlink_Security], m_Airlink_Security);
        tree.Append(basePathName, WiMAXFieldName[e_Certificates], m_Certificates);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << WiMAX::Serialize. Res: 1");
        return true;
    }
    //-------------------------------------------------------------------------------------------

    bool WiMAX::Deserialize(const String& basePathName, TNDSExtractor& tree)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> WiMAX::Deserialize");

        tree.GetValue(basePathName, WiMAXFieldName[e_ServBSID], m_ServBSID);
        tree.GetValue(basePathName, WiMAXFieldName[e_DownlinkFreq], m_DownlinkFreq);
        tree.GetValue(basePathName, WiMAXFieldName[e_DownlinkBandwidth], m_DownlinkBandwidth);
        tree.GetValue(basePathName, WiMAXFieldName[e_DownlinkMeanRSSI], m_DownlinkMeanRSSI);
        tree.GetValue(basePathName, WiMAXFieldName[e_DownlinkStdDevRSSI], m_DownlinkStdDevRSSI);
        tree.GetValue(basePathName, WiMAXFieldName[e_DownlinkMeanCINR], m_DownlinkMeanCINR);
        tree.GetValue(basePathName, WiMAXFieldName[e_DownlinkStdDevCINR], m_DownlinkStdDevCINR);
        tree.GetValue(basePathName, WiMAXFieldName[e_TxPwr], m_TxPwr);
        tree.GetValue(basePathName, WiMAXFieldName[e_TxHeadroomPwr], m_TxHeadroomPwr);
        tree.GetValue(basePathName, WiMAXFieldName[e_ScannedBaseStations], m_ScannedBaseStations);
        tree.GetValue(basePathName, WiMAXFieldName[e_LinkUptime], m_LinkUptime);
        tree.GetValue(basePathName, WiMAXFieldName[e_HARQRetTX], m_HARQRetTX);
        tree.GetValue(basePathName, WiMAXFieldName[e_HARQRetRX], m_HARQRetRX);
        tree.GetValue(basePathName, WiMAXFieldName[e_InitRangeResp], m_InitRangeResp);
        tree.GetValue(basePathName, WiMAXFieldName[e_InitRangeNoResp], m_InitRangeNoResp);
        tree.GetValue(basePathName, WiMAXFieldName[e_PerRangeResp], m_PerRangeResp);
        tree.GetValue(basePathName, WiMAXFieldName[e_PerRangeNoResp], m_PerRangeNoResp);
        tree.GetValue(basePathName, WiMAXFieldName[e_HOSuccess], m_HOSuccess);
        tree.GetValue(basePathName, WiMAXFieldName[e_HOFail], m_HOFail);
        tree.GetValue(basePathName, WiMAXFieldName[e_MAPRecSuccess], m_MAPRecSuccess);
        tree.GetValue(basePathName, WiMAXFieldName[e_MAPRecFail], m_MAPRecFail);
        tree.GetValue(basePathName, WiMAXFieldName[e_MCSstatsDL], m_MCSstatsDL);
        tree.GetValue(basePathName, WiMAXFieldName[e_MCSstatsUL], m_MCSstatsUL);
        tree.GetValue(basePathName, WiMAXFieldName[e_VersionOfMCSMetric], m_VersionOfMCSMetric);
        tree.GetValue(basePathName, WiMAXFieldName[e_DownlinkDataRate], m_DownlinkDataRate);
        tree.GetValue(basePathName, WiMAXFieldName[e_UplinkDataRate], m_UplinkDataRate);
        tree.GetValue(basePathName, WiMAXFieldName[e_PacketsReceived], m_PacketsReceived);
        tree.GetValue(basePathName, WiMAXFieldName[e_PacketsSent], m_PacketsSent);
        // DMRD SDK specific fields
        tree.GetValue(basePathName, WiMAXFieldName[e_MACState], m_MACState);
        tree.GetValue(basePathName, WiMAXFieldName[e_PreambleIndex], m_PreambleIndex);
        tree.GetValue(basePathName, WiMAXFieldName[e_HOLatency], m_HOLatency);
        tree.GetValue(basePathName, WiMAXFieldName[e_FrameRatio], m_FrameRatio);
        tree.GetValue(basePathName, WiMAXFieldName[e_HOAttempts], m_HOAttempts);
        tree.GetValue(basePathName, WiMAXFieldName[e_NetworkEntryLatency], m_NetworkEntryLatency);
        tree.GetValue(basePathName, WiMAXFieldName[e_NetworkEntrySucceses], m_NetworkEntrySucceses);
        tree.GetValue(basePathName, WiMAXFieldName[e_NetworkEntryFailures], m_NetworkEntryFailures);
        tree.GetValue(basePathName, WiMAXFieldName[e_NetworkEntryAttempts], m_NetworkEntryAttempts);
        tree.GetValue(basePathName, WiMAXFieldName[e_UserAccessTime], m_UserAccessTime);
        // BA PARAMS NOT IN DRMD ? CR PENDING
        tree.GetValue(basePathName, WiMAXFieldName[e_ARQ_Retries_Received], m_ARQ_Retries_Received);
        tree.GetValue(basePathName, WiMAXFieldName[e_ARQ_Retries_Transmitted], m_ARQ_Retries_Transmitted);
        tree.GetValue(basePathName, WiMAXFieldName[e_CQICH], m_CQICH);
        tree.GetValue(basePathName, WiMAXFieldName[e_Service_Flows], m_Service_Flows);
        tree.GetValue(basePathName, WiMAXFieldName[e_Airlink_Security], m_Airlink_Security);
        tree.GetValue(basePathName, WiMAXFieldName[e_Certificates], m_Certificates);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << WiMAX::Deserialize. Res: 1");
        return true;
    }

    //-------------------------------------------------------------------------------------------
    //-------------------------------------------------------------------------------------------
    //-------------------------------------------------------------------------------------------

    bool Generic::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Generic::Serialize");

        bool res = NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_RateLimiterStats], ToString(m_RateLimiterStats), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_TimeActive], ToString(m_TimeActive), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_TimeIdle], ToString(m_TimeIdle), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_TimeSleep], ToString(m_TimeSleep), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_LastRebootCause], m_LastRebootCause, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_DeviceTemp], ToString(m_DeviceTemp), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_SupVolt], ToString(m_SupVolt), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_BatteryCap], ToString(m_BatteryCap), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_GPSlocation_Latitude], ToString(m_GPSlocation_Latitude), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_GPSlocation_Longitude], ToString(m_GPSlocation_Longitude), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_GPSlocation_Altitude], ToString(m_GPSlocation_Altitude), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_Enable], m_LANEtherMAC.m_Enable, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_MACAddressControlEnabled], m_LANEtherMAC.m_MACAddressControlEnabled, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_MaxBitrate], m_LANEtherMAC.m_MaxBitrate, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_DuplexMode], m_LANEtherMAC.m_DuplexMode, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_LANEtherMACresults], m_LANEtherMAC.m_LANEtherMACresults, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_DiagnosticsState], m_IPPingDiagnostics.m_DiagnosticsState, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_Interface], m_IPPingDiagnostics.m_Interface, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_Host], m_IPPingDiagnostics.m_Host, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_NumberOfRepetition], ToString(m_IPPingDiagnostics.m_NumberOfRepetition), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_Timeout], ToString(m_IPPingDiagnostics.m_Timeout), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_DataBlockSize], ToString(m_IPPingDiagnostics.m_DataBlockSize), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_DSCP], ToString(m_IPPingDiagnostics.m_DSCP), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_IPPingDiagnosticsResults], m_IPPingDiagnostics.m_IPPingDiagnosticsResults, treeManager);
        // NOT IN DRMD SPEC BUT WILL BE SUBMITTED AS CR
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_DeviceUptime], ToString(m_DeviceUptime), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_DeviceLog], m_DeviceLog, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_Primary_DNS], m_Primary_DNS, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_Secondary_DNS], m_Secondary_DNS, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_Gateway], m_Gateway, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_Subnet_Mask], m_Subnet_Mask, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_Wimax_Interface_IP_Addr], m_Wimax_Interface_IP_Addr, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_DHCP_Leases], ToString(m_DHCP_Leases), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + GenericFieldName[e_Port_Forwarding], m_Port_Forwarding, treeManager);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEVAE << Generic::Serialize. Res: %d", res);
        return res;
    }

    //-------------------------------------------------------------------------------------------

    bool Generic::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Generic::Deserialize");

        bool res = NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_RateLimiterStats], m_RateLimiterStats, treeManager);       
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_TimeActive], m_TimeActive, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_TimeIdle], m_TimeIdle, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_TimeSleep], m_TimeSleep, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_LastRebootCause], m_LastRebootCause, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_DeviceTemp], m_DeviceTemp, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_SupVolt], m_SupVolt, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_BatteryCap], m_BatteryCap, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_GPSlocation_Latitude], m_GPSlocation_Latitude, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_GPSlocation_Longitude], m_GPSlocation_Longitude, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_GPSlocation_Altitude], m_GPSlocation_Altitude, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_Enable], m_LANEtherMAC.m_Enable, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_MACAddressControlEnabled], m_LANEtherMAC.m_MACAddressControlEnabled, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_MaxBitrate], m_LANEtherMAC.m_MaxBitrate, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_DuplexMode], m_LANEtherMAC.m_DuplexMode, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_LANEtherMAC_LANEtherMACresults], m_LANEtherMAC.m_LANEtherMACresults, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_DiagnosticsState], m_IPPingDiagnostics.m_DiagnosticsState, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_Interface], m_IPPingDiagnostics.m_Interface, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_Host], m_IPPingDiagnostics.m_Host, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_NumberOfRepetition], m_IPPingDiagnostics.m_NumberOfRepetition, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_Timeout], m_IPPingDiagnostics.m_Timeout, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_DataBlockSize], m_IPPingDiagnostics.m_DataBlockSize, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_DSCP], m_IPPingDiagnostics.m_DSCP, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_IPPingDiagnostics_IPPingDiagnosticsResults], m_IPPingDiagnostics.m_IPPingDiagnosticsResults, treeManager);
        // NOT IN DRMD SPEC BUT WILL BE SUBMITTED AS CR
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_DeviceUptime], m_DeviceUptime, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_DeviceLog], m_DeviceLog, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_Primary_DNS], m_Primary_DNS, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_Secondary_DNS], m_Secondary_DNS, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_Gateway], m_Gateway, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_Subnet_Mask], m_Subnet_Mask, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_Wimax_Interface_IP_Addr], m_Wimax_Interface_IP_Addr, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_DHCP_Leases], m_DHCP_Leases, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + GenericFieldName[e_Port_Forwarding], m_Port_Forwarding, treeManager);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEVAE << Generic::Deserialize. Res: %d", res);
        return res;
    }

    //-------------------------------------------------------------------------------------------

    bool Generic::Serialize(const String& basePathName, TNDSCreator& tree) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Generic::Serialize");

        tree.Append(basePathName, GenericFieldName[e_RateLimiterStats], ToString(m_RateLimiterStats));
        tree.Append(basePathName, GenericFieldName[e_TimeActive], ToString(m_TimeActive));
        tree.Append(basePathName, GenericFieldName[e_TimeIdle], ToString(m_TimeIdle));
        tree.Append(basePathName, GenericFieldName[e_TimeSleep], ToString(m_TimeSleep));
        tree.Append(basePathName, GenericFieldName[e_LastRebootCause], (size_t)e_TimeSleep);
        tree.Append(basePathName, GenericFieldName[e_DeviceTemp], ToString(m_DeviceTemp));
        tree.Append(basePathName, GenericFieldName[e_SupVolt], ToString(m_SupVolt));
        tree.Append(basePathName, GenericFieldName[e_BatteryCap], ToString(m_BatteryCap));
        tree.Append(basePathName, GenericFieldName[e_GPSlocation_Latitude], ToString(m_GPSlocation_Latitude));
        tree.Append(basePathName, GenericFieldName[e_GPSlocation_Longitude], ToString(m_GPSlocation_Longitude));
        tree.Append(basePathName, GenericFieldName[e_GPSlocation_Altitude], ToString(m_GPSlocation_Altitude));
        tree.Append(basePathName, GenericFieldName[e_LANEtherMAC_Enable], m_LANEtherMAC.m_Enable);
        tree.Append(basePathName, GenericFieldName[e_LANEtherMAC_MACAddressControlEnabled], m_LANEtherMAC.m_MACAddressControlEnabled);
        tree.Append(basePathName, GenericFieldName[e_LANEtherMAC_MaxBitrate], m_LANEtherMAC.m_MaxBitrate);
        tree.Append(basePathName, GenericFieldName[e_LANEtherMAC_DuplexMode], m_LANEtherMAC.m_DuplexMode);
        tree.Append(basePathName, GenericFieldName[e_LANEtherMAC_LANEtherMACresults], m_LANEtherMAC.m_LANEtherMACresults);
        tree.Append(basePathName, GenericFieldName[e_IPPingDiagnostics_DiagnosticsState], m_IPPingDiagnostics.m_DiagnosticsState);
        tree.Append(basePathName, GenericFieldName[e_IPPingDiagnostics_Interface], m_IPPingDiagnostics.m_Interface);
        tree.Append(basePathName, GenericFieldName[e_IPPingDiagnostics_Host], m_IPPingDiagnostics.m_Host);
        tree.Append(basePathName, GenericFieldName[e_IPPingDiagnostics_NumberOfRepetition], ToString(m_IPPingDiagnostics.m_NumberOfRepetition));
        tree.Append(basePathName, GenericFieldName[e_IPPingDiagnostics_Timeout], ToString(m_IPPingDiagnostics.m_Timeout));
        tree.Append(basePathName, GenericFieldName[e_IPPingDiagnostics_DataBlockSize], ToString(m_IPPingDiagnostics.m_DataBlockSize));
        tree.Append(basePathName, GenericFieldName[e_IPPingDiagnostics_DSCP], ToString(m_IPPingDiagnostics.m_DSCP));
        tree.Append(basePathName, GenericFieldName[e_IPPingDiagnostics_IPPingDiagnosticsResults], m_IPPingDiagnostics.m_IPPingDiagnosticsResults);
        // NOT IN DRMD SPEC BUT WILL BE SUBMITTED AS CR
        tree.Append(basePathName, GenericFieldName[e_DeviceUptime], ToString(m_DeviceUptime));
        tree.Append(basePathName, GenericFieldName[e_DeviceLog], m_DeviceLog);
        tree.Append(basePathName, GenericFieldName[e_Primary_DNS], m_Primary_DNS);
        tree.Append(basePathName, GenericFieldName[e_Secondary_DNS], m_Secondary_DNS);
        tree.Append(basePathName, GenericFieldName[e_Gateway], m_Gateway);
        tree.Append(basePathName, GenericFieldName[e_Subnet_Mask], m_Subnet_Mask);
        tree.Append(basePathName, GenericFieldName[e_Wimax_Interface_IP_Addr], m_Wimax_Interface_IP_Addr);
        tree.Append(basePathName, GenericFieldName[e_DHCP_Leases], ToString(m_DHCP_Leases));
        tree.Append(basePathName, GenericFieldName[e_Port_Forwarding], m_Port_Forwarding);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Generic::Serialize. Res: 1");
        return true;
    }
    //-------------------------------------------------------------------------------------------

    bool Generic::Deserialize(const String& basePathName, TNDSExtractor& tree)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Generic::Deserialize");

        tree.GetValue(basePathName, GenericFieldName[e_RateLimiterStats], m_RateLimiterStats);
        tree.GetValue(basePathName, GenericFieldName[e_TimeActive], m_TimeActive);
        tree.GetValue(basePathName, GenericFieldName[e_TimeIdle], m_TimeIdle);
        tree.GetValue(basePathName, GenericFieldName[e_TimeSleep], m_TimeSleep);
        tree.GetValue(basePathName, GenericFieldName[e_LastRebootCause], m_LastRebootCause);
        tree.GetValue(basePathName, GenericFieldName[e_DeviceTemp], m_DeviceTemp);
        tree.GetValue(basePathName, GenericFieldName[e_SupVolt], m_SupVolt);
        tree.GetValue(basePathName, GenericFieldName[e_BatteryCap], m_BatteryCap);
        tree.GetValue(basePathName, GenericFieldName[e_GPSlocation_Latitude], m_GPSlocation_Latitude);
        tree.GetValue(basePathName, GenericFieldName[e_GPSlocation_Longitude], m_GPSlocation_Longitude);
        tree.GetValue(basePathName, GenericFieldName[e_GPSlocation_Altitude], m_GPSlocation_Altitude);
        tree.GetValue(basePathName, GenericFieldName[e_LANEtherMAC_Enable], m_LANEtherMAC.m_Enable);
        tree.GetValue(basePathName, GenericFieldName[e_LANEtherMAC_MACAddressControlEnabled], m_LANEtherMAC.m_MACAddressControlEnabled);
        tree.GetValue(basePathName, GenericFieldName[e_LANEtherMAC_MaxBitrate], m_LANEtherMAC.m_MaxBitrate);
        tree.GetValue(basePathName, GenericFieldName[e_LANEtherMAC_DuplexMode], m_LANEtherMAC.m_DuplexMode);
        tree.GetValue(basePathName, GenericFieldName[e_LANEtherMAC_LANEtherMACresults], m_LANEtherMAC.m_LANEtherMACresults);
        tree.GetValue(basePathName, GenericFieldName[e_IPPingDiagnostics_DiagnosticsState], m_IPPingDiagnostics.m_DiagnosticsState);
        tree.GetValue(basePathName, GenericFieldName[e_IPPingDiagnostics_Interface], m_IPPingDiagnostics.m_Interface);
        tree.GetValue(basePathName, GenericFieldName[e_IPPingDiagnostics_Host], m_IPPingDiagnostics.m_Host);
        tree.GetValue(basePathName, GenericFieldName[e_IPPingDiagnostics_NumberOfRepetition], m_IPPingDiagnostics.m_NumberOfRepetition);
        tree.GetValue(basePathName, GenericFieldName[e_IPPingDiagnostics_Timeout], m_IPPingDiagnostics.m_Timeout);
        tree.GetValue(basePathName, GenericFieldName[e_IPPingDiagnostics_DataBlockSize], m_IPPingDiagnostics.m_DataBlockSize);
        tree.GetValue(basePathName, GenericFieldName[e_IPPingDiagnostics_DSCP], m_IPPingDiagnostics.m_DSCP);
        tree.GetValue(basePathName, GenericFieldName[e_IPPingDiagnostics_DSCP], m_IPPingDiagnostics.m_DSCP);
        // NOT IN DRMD SPEC BUT WILL BE SUBMITTED AS CR
        tree.GetValue(basePathName, GenericFieldName[e_DeviceUptime], m_DeviceUptime);
        tree.GetValue(basePathName, GenericFieldName[e_DeviceLog], m_DeviceLog);
        tree.GetValue(basePathName, GenericFieldName[e_Primary_DNS], m_Primary_DNS);
        tree.GetValue(basePathName, GenericFieldName[e_Secondary_DNS], m_Secondary_DNS);
        tree.GetValue(basePathName, GenericFieldName[e_Gateway], m_Gateway);
        tree.GetValue(basePathName, GenericFieldName[e_Subnet_Mask], m_Subnet_Mask);
        tree.GetValue(basePathName, GenericFieldName[e_Wimax_Interface_IP_Addr], m_Wimax_Interface_IP_Addr);
        tree.GetValue(basePathName, GenericFieldName[e_DHCP_Leases], m_DHCP_Leases);
        tree.GetValue(basePathName, GenericFieldName[e_Port_Forwarding], m_Port_Forwarding);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Generic::Deserialize. Res: 1");       
        return true;
    }

    //-------------------------------------------------------------------------------------------
    //-------------------------------------------------------------------------------------------
    //-------------------------------------------------------------------------------------------

    bool Ext::Serialize(const String& basePathName, IMOTreeManager& treeManager) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Ext::Serialize");

        bool res = NS_DM_Client::Serialize(basePathName + S_slash + ExtFieldName[e_Platform_Memory], ToString(m_Platform_Memory), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + ExtFieldName[e_Processor_id], ToString(m_Processor_id), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + ExtFieldName[e_Processor_type], m_Processor_type, treeManager);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + ExtFieldName[e_CPU_Utilization], ToString(m_CPU_Utilization), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + ExtFieldName[e_RAM_Utilization], ToString(m_RAM_Utilization), treeManager, S_intFormat);
        res &= NS_DM_Client::Serialize(basePathName + S_slash + ExtFieldName[e_Hard_Drive_Number], m_Hard_Drive_Number, treeManager);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Ext::Serialize. Res: %d", res);
        return res;
    }

    //-------------------------------------------------------------------------------------------

    bool Ext::Deserialize(const String& basePathName, IMOTreeManager& treeManager)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Ext::Deserialize");

        bool res = NS_DM_Client::Deserialize(basePathName + S_slash + ExtFieldName[e_Platform_Memory], m_Platform_Memory, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + ExtFieldName[e_Processor_id], m_Processor_id, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + ExtFieldName[e_Processor_type], m_Processor_type, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + ExtFieldName[e_CPU_Utilization], m_CPU_Utilization, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + ExtFieldName[e_RAM_Utilization], m_RAM_Utilization, treeManager);
        res &= NS_DM_Client::Deserialize(basePathName + S_slash + ExtFieldName[e_Hard_Drive_Number], m_Hard_Drive_Number, treeManager);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Ext::Deserialize. Res: %d", res);
        return res;
    }

    //-------------------------------------------------------------------------------------------

    bool Ext::Serialize(const String& basePathName, TNDSCreator& tree) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Ext::Serialize");

        tree.Append(basePathName, ExtFieldName[e_Platform_Memory], ToString(m_Platform_Memory));
        tree.Append(basePathName, ExtFieldName[e_Processor_id], ToString(m_Processor_id));
        tree.Append(basePathName, ExtFieldName[e_Processor_type], m_Processor_type);
        tree.Append(basePathName, ExtFieldName[e_CPU_Utilization], ToString(m_CPU_Utilization));
        tree.Append(basePathName, ExtFieldName[e_RAM_Utilization], ToString(m_RAM_Utilization));
        tree.Append(basePathName, ExtFieldName[e_Hard_Drive_Number], m_Hard_Drive_Number);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Ext::Serialize. Res: 1");
        return true;
    }

    //-------------------------------------------------------------------------------------------

    bool Ext::Deserialize(const String& basePathName, TNDSExtractor& tree)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> Ext::Deserialize");

        tree.GetValue(basePathName, ExtFieldName[e_Platform_Memory], m_Platform_Memory);
        tree.GetValue(basePathName, ExtFieldName[e_Processor_id], m_Processor_id);
        tree.GetValue(basePathName, ExtFieldName[e_Processor_type], m_Processor_type);
        tree.GetValue(basePathName, ExtFieldName[e_CPU_Utilization], m_CPU_Utilization);
        tree.GetValue(basePathName, ExtFieldName[e_RAM_Utilization], m_RAM_Utilization);
        tree.GetValue(basePathName, ExtFieldName[e_Hard_Drive_Number], m_Hard_Drive_Number);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << Ext::Deserialize. Res: 1");
        return true;
    }

    //-------------------------------------------------------------------------------------------
    //-------------------------------------------------------------------------------------------
    //-------------------------------------------------------------------------------------------

    bool WiMAX_Diagnostics::Execute()
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> WiMAX_Diagnostics::Execute");

        bool res = false;

        ST_Diag_Start_P startBranch;
        ST_Diag_WiMAX_P wimaxBranch;
        ST_Diag_Generic_P genericBranch;
        ST_Diag_Ext_P extBranch;

        if ((SetDiagnosticsStart(&startBranch)) && (SetDiagnosticsWiMAX(&wimaxBranch)) && (SetDiagnosticsGeneric(&genericBranch)) && (SetDiagnosticsExt(&extBranch)))
        {
            res = true;
            res &= TranslateStart(startBranch, m_Start);
            res &= TranslateWiMAX(wimaxBranch, m_WiMAX);
            res &= TranslateGeneric(genericBranch, m_Generic);
            res &= TranslateExt(extBranch, m_Ext);
        }

        ReleaseDiagnosticsExt(extBranch);
        ReleaseDiagnosticsGeneric(genericBranch);
        ReleaseDiagnosticsWiMAX(wimaxBranch);
        ReleaseDiagnosticsStart(startBranch);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << WiMAX_Diagnostics::Execute. Res: %d", res);
        return res;
    }

    //-------------------------------------------------------------------------------------------

    bool WiMAX_Diagnostics::Serialize(IMOTreeManager& treeManager) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> WiMAX_Diagnostics::Serialize");

        bool res = m_Start.Serialize(WiMAX_DiagnisticsFieldPath[e_Start] + S_slash + WiMAX_DiagnisticsFieldName[e_Start], treeManager);
        res &= m_WiMAX.Serialize(WiMAX_DiagnisticsFieldPath[e_WiMAX] + S_slash + WiMAX_DiagnisticsFieldName[e_WiMAX], treeManager);
        res &= m_Generic.Serialize(WiMAX_DiagnisticsFieldPath[e_Generic] + S_slash + WiMAX_DiagnisticsFieldName[e_Generic], treeManager);
        res &= m_Ext.Serialize(WiMAX_DiagnisticsFieldPath[e_Ext] + S_slash + WiMAX_DiagnisticsFieldName[e_Ext], treeManager);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << WiMAX_Diagnostics::Serialize. Res: %d", res);
        return res;
    }

    //-------------------------------------------------------------------------------------------

    bool WiMAX_Diagnostics::Deserialize(IMOTreeManager& treeManager)
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> WiMAX_Diagnostics::Deserialize");

        bool res =  m_Start.Deserialize(WiMAX_DiagnisticsFieldPath[e_Start] + S_slash + WiMAX_DiagnisticsFieldName[e_Start], treeManager);    
        res &= m_WiMAX.Deserialize(WiMAX_DiagnisticsFieldPath[e_WiMAX] + S_slash + WiMAX_DiagnisticsFieldName[e_WiMAX], treeManager);
        res &= m_Generic.Deserialize(WiMAX_DiagnisticsFieldPath[e_Generic] + S_slash + WiMAX_DiagnisticsFieldName[e_Generic], treeManager);
        res &= m_Ext.Deserialize(WiMAX_DiagnisticsFieldPath[e_Ext] + S_slash + WiMAX_DiagnisticsFieldName[e_Ext], treeManager);
        
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << WiMAX_Diagnostics::Deserialize. Res: %d", res);
        return res;
    }

    //-------------------------------------------------------------------------------------------

    bool WiMAX_Diagnostics::Serialize(String& xml) const
    {
        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "ENTER >> WiMAX_Diagnostics::Serialize");

        TNDSCreator tree;
        bool res = m_Start.Serialize(WiMAX_DiagnisticsFieldPath[e_Start] + S_slash + WiMAX_DiagnisticsFieldName[e_Start], tree);
        res &= m_WiMAX.Serialize(WiMAX_DiagnisticsFieldPath[e_WiMAX] + S_slash + WiMAX_DiagnisticsFieldName[e_WiMAX], tree);
        res &= m_Generic.Serialize(WiMAX_DiagnisticsFieldPath[e_Generic] + S_slash + WiMAX_DiagnisticsFieldName[e_Generic], tree);
        res &= m_Ext.Serialize(WiMAX_DiagnisticsFieldPath[e_Ext] + S_slash + WiMAX_DiagnisticsFieldName[e_Ext], tree);
        tree.Get(xml);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << WiMAX_Diagnostics::Serialize. Res: %d", res);
        return res;
    }

    //-------------------------------------------------------------------------------------------

    bool WiMAX_Diagnostics::Deserialize(const String& xml)
    {
        TNDSExtractor tree(xml);
        bool res = m_Start.Deserialize(WiMAX_DiagnisticsFieldPath[e_Start] + S_slash + WiMAX_DiagnisticsFieldName[e_Start], tree);
        res &= m_WiMAX.Deserialize(WiMAX_DiagnisticsFieldPath[e_WiMAX] + S_slash + WiMAX_DiagnisticsFieldName[e_WiMAX], tree);
        res &= m_Generic.Deserialize(WiMAX_DiagnisticsFieldPath[e_Generic] + S_slash + WiMAX_DiagnisticsFieldName[e_Generic], tree);
        res &= m_Ext.Deserialize(WiMAX_DiagnisticsFieldPath[e_Ext] + S_slash + WiMAX_DiagnisticsFieldName[e_Ext], tree);

        LOG_DEBUG_(NS_Logging::GetLogger(c_DiagnosticsLog), "LEAVE << WiMAX_Diagnostics::Deserialize. Res: %d", res);
        return res;
    }

    //-------------------------------------------------------------------------------------------

}
}
