#include "../stdafx.h"
#include "SysLog.h"
#include <syslog.h>
#include <stdio.h>

namespace NS_Logging
{
	//-------------------------------------------------------------------------------------------
	SysLog::~SysLog()
	{
		closelog();
	}
	//-------------------------------------------------------------------------------------------

	void SysLog::Open(const char* ident)
	{
		String s(ident);
		m_ident = s;
	}
	//-------------------------------------------------------------------------------------------

	void SysLog::Write(const char* buffer, int size)
	{
		syslog(LOG_ERR, buffer);
	}
	//-------------------------------------------------------------------------------------------

	int SysLog::FormatMessage(char* buffer, int size, int threadID, const char* loggerName, 
			const char* category, const char* functionName)
	{
		int written = snprintf(buffer, size, "[%8x] %s %s %s: ", threadID, loggerName, functionName, category);
		return written;
	}
	//-------------------------------------------------------------------------------------------
	
	int SysLog::FormatMessage(char* buffer, int size, int threadID, const char* loggerName, 
			const char* category)
	{
		int written = snprintf(buffer, size, "[%8x] %s %s: ", threadID, loggerName, category);
		return written;
	}
	//-------------------------------------------------------------------------------------------
}
