/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "NotificationListener/ProcessBootstrapCommand.h"
#include "daemon/ProfileComponentsHolder.h"
#include "serverexchange/IServerExchangeManager.h"

using namespace NS_DM_Client::NS_NotificationListener;
using namespace NS_DM_Client;

ProcessBootstrapCommand::ProcessBootstrapCommand(buffer_t& bcdata, IServerExchangeManager &sem)
	: ServerExchangeCommand(sem)
{
    m_bcdata.swap(bcdata);
}


bool ProcessBootstrapCommand::Execute()
{
    m_SEM.ProcessBootstrapMessage(&m_bcdata[0], m_bcdata.size());
    return true;
}
