/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "common/Buffer.h"

namespace NS_DM_Client
{

//------------------------------------------------------------------------------------------------------
Buffer::Buffer()
{
}
//------------------------------------------------------------------------------------------------------
Buffer::Buffer(const size_t size)
{
    m_Data.resize(size);
}
//------------------------------------------------------------------------------------------------------
Buffer::Buffer(const size_t size, const char val)
{
    m_Data.resize(size, val);
}
//------------------------------------------------------------------------------------------------------
Buffer::~Buffer()
{
}
//------------------------------------------------------------------------------------------------------
bool Buffer::Allocate(const size_t size)
{
    bool res = (size > 0);
    if (res)
    {
        m_Data.resize(size);
    }
    return res;
}
//------------------------------------------------------------------------------------------------------
bool Buffer::Allocate(const size_t size, const char val)
{
    bool res = (size > 0);
    if (res)
    {
        m_Data.resize(size, val);
    }
    return res;
}
//------------------------------------------------------------------------------------------------------
size_t Buffer::Size() const
{
    return m_Data.size();
}
//------------------------------------------------------------------------------------------------------
void* Buffer::GetPointer()
{
    if (m_Data.size() > 0)
    {
        return (&m_Data[0]);
    }
    return 0;
}
//------------------------------------------------------------------------------------------------------
const void* Buffer::GetPointer() const
{
    if (m_Data.size() > 0)
    {
        return (&m_Data[0]);
    }
    return 0;
}
//------------------------------------------------------------------------------------------------------
bool Buffer::Release()
{
    m_Data.clear();
    return true;
}
//------------------------------------------------------------------------------------------------------
void  Buffer::Clear()
{
    if (m_Data.size() > 0)
    {
        memset(&m_Data[0], 0, m_Data.size());
    }
}
//------------------------------------------------------------------------------------------------------
}
